/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionElement {
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;
    private final Object myEqualityObject;

    public CompletionElement(Object element, PsiSubstitutor substitutor) {
        this.myElement = element;
        this.mySubstitutor = substitutor;
        this.myEqualityObject = this.getUniqueId();
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    @Nullable
    private Object getUniqueId() {
        if (this.myElement instanceof PsiClass) {
            String qName = ((PsiClass)this.myElement).getQualifiedName();
            return qName == null ? ((PsiClass)this.myElement).getName() : qName;
        }
        if (this.myElement instanceof PsiPackage) {
            return ((PsiPackage)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiMethod) {
            return ((PsiMethod)this.myElement).getSignature(this.mySubstitutor);
        }
        if (this.myElement instanceof PsiVariable) {
            return "#" + ((PsiVariable)this.myElement).getName();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompletionElement)) {
            return false;
        }
        Object thatObj = ((CompletionElement)obj).myEqualityObject;
        if (this.myEqualityObject instanceof MethodSignature) {
            return thatObj instanceof MethodSignature && MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)((MethodSignature)this.myEqualityObject), (Object)((MethodSignature)thatObj));
        }
        return Comparing.equal((Object)this.myEqualityObject, (Object)thatObj);
    }

    public int hashCode() {
        if (this.myEqualityObject instanceof MethodSignature) {
            return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)((MethodSignature)this.myEqualityObject));
        }
        return this.myEqualityObject != null ? this.myEqualityObject.hashCode() : 0;
    }

    public boolean isMoreSpecificThan(@NotNull CompletionElement prev) {
        Object prevElement = prev.getElement();
        if (!(prevElement instanceof PsiMethod) || !(this.myElement instanceof PsiMethod)) {
            return false;
        }
        PsiType prevType = prev.getSubstitutor().substitute(((PsiMethod)prevElement).getReturnType());
        PsiType candidateType = this.mySubstitutor.substitute(((PsiMethod)this.myElement).getReturnType());
        return prevType != null && candidateType != null && !prevType.equals(candidateType) && prevType.isAssignableFrom(candidateType);
    }
}

