/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    @Nullable
    private final CamelHumpMatcher myHumpMatcher;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myHumpMatcher = original instanceof CamelHumpMatcher ? (CamelHumpMatcher)original : null;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    public BetterPrefixMatcher(CompletionResultSet set) {
        this(set.getPrefixMatcher(), Integer.MIN_VALUE);
    }

    @NotNull
    public BetterPrefixMatcher improve(CompletionResult result) {
        int degree = RealPrefixMatchingWeigher.getBestMatchingDegree(result.getLookupElement(), result.getPrefixMatcher());
        if (degree <= this.myMinMatchingDegree) {
            return this;
        }
        return new BetterPrefixMatcher(this.myOriginal, degree);
    }

    public boolean prefixMatches(@NotNull String name) {
        if (this.myHumpMatcher != null) {
            FList<TextRange> fragments = this.myHumpMatcher.matchingFragments(name);
            if (fragments == null || !MinusculeMatcher.isStartMatch(fragments)) {
                return false;
            }
            return this.myHumpMatcher.matchingDegree(name, fragments) >= this.myMinMatchingDegree;
        }
        if (!this.myOriginal.prefixMatches(name) || !this.myOriginal.isStartMatch(name)) {
            return false;
        }
        return this.myOriginal.matchingDegree(name) >= this.myMinMatchingDegree;
    }

    public boolean isStartMatch(String name) {
        return this.myOriginal.isStartMatch(name);
    }

    public int matchingDegree(String string) {
        return this.myOriginal.matchingDegree(string);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        return new BetterPrefixMatcher(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
    }
}

