/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.XmlSmartEnterProcessor");

    public boolean process(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        return this.completeEndTag(project2, editor, psiFile);
    }

    private boolean completeEndTag(Project project2, Editor editor, PsiFile psiFile) {
        PsiElement atCaret = this.getStatementAtCaret(editor, psiFile);
        XmlTag tagAtCaret = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlTag.class);
        if (tagAtCaret == null) {
            return false;
        }
        try {
            ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            ASTNode endTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            Document doc = editor.getDocument();
            if (emptyTagEnd == null && endTagEnd == null) {
                char ch;
                int insertionOffset = tagAtCaret.getTextRange().getEndOffset();
                int caretAt = editor.getCaretModel().getOffset();
                CharSequence text = doc.getCharsSequence();
                int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)insertionOffset, (String)" \t");
                PsiElement sibling = tagAtCaret.getNextSibling();
                int caretTo = caretAt;
                if (caretAt < probableCommaOffset) {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    CharSequence tagNameText = null;
                    if (xmlAttribute != null) {
                        ASTNode tagName;
                        ASTNode node = tagAtCaret.getNode();
                        if (node != null && (tagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node)) != null) {
                            tagNameText = tagName.getText();
                        }
                        XmlAttributeValue valueElement = xmlAttribute.getValueElement();
                        TextRange textRange = xmlAttribute.getTextRange();
                        int n = valueElement == null ? textRange.getStartOffset() : (caretAt = XmlSmartEnterProcessor.getClosingQuote(xmlAttribute).length() == 0 ? textRange.getEndOffset() : caretAt);
                    }
                    if (tagNameText == null) {
                        tagNameText = text.subSequence(tagAtCaret.getTextRange().getStartOffset() + 1, caretAt);
                    }
                    PsiElement element = psiFile.findElementAt(probableCommaOffset);
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
                    boolean shouldInsertClosingTag = this.shouldAfterWrapTextWithTag(caretAt, probableCommaOffset) || this.shouldInsertClosingTag(xmlAttribute, tagAtCaret);
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, !shouldInsertClosingTag);
                    if (tag != null && tag.getTextRange().getStartOffset() == probableCommaOffset) {
                        doc.insertString(caretAt, (CharSequence)text2insert);
                        if (shouldInsertClosingTag) {
                            doc.insertString(tag.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                        }
                        caretTo = tag.getTextRange().getEndOffset() + text2insert.length();
                    } else {
                        doc.insertString(caretAt, (CharSequence)text2insert);
                        if (shouldInsertClosingTag) {
                            doc.insertString(probableCommaOffset + text2insert.length(), (CharSequence)("</" + tagNameText + ">"));
                        }
                        caretTo = probableCommaOffset + text2insert.length();
                    }
                } else if (sibling instanceof XmlTag && sibling.getTextRange().getStartOffset() == caretAt) {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, false);
                    doc.insertString(caretAt, (CharSequence)text2insert);
                    if (this.shouldInsertClosingTag(xmlAttribute, tagAtCaret)) {
                        doc.insertString(sibling.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                    }
                    caretTo = sibling.getTextRange().getEndOffset() + text2insert.length();
                } else if (probableCommaOffset >= text.length() || (ch = text.charAt(probableCommaOffset)) != '/' && ch != '>') {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, true);
                    doc.insertString(insertionOffset, (CharSequence)text2insert);
                    caretTo = insertionOffset + text2insert.length();
                }
                this.commitChanges(project2, editor, psiFile, caretTo, null);
                return true;
            }
            XmlTag unclosedTag = XmlSmartEnterProcessor.findClosestUnclosedTag(tagAtCaret);
            if (unclosedTag == null) {
                return false;
            }
            String closingTagString = "</" + unclosedTag.getName() + ">";
            XmlTag parentTag = unclosedTag.getParentTag();
            ASTNode parentEndTagNode = parentTag != null ? XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentTag.getNode()) : null;
            int offset = parentEndTagNode != null ? parentEndTagNode.getTextRange().getStartOffset() : unclosedTag.getTextRange().getEndOffset();
            doc.insertString(offset, (CharSequence)closingTagString);
            this.commitChanges(project2, editor, psiFile, offset, parentTag != null ? parentTag : unclosedTag);
            return true;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    protected boolean shouldAfterWrapTextWithTag(int caretAt, int probableCommaOffset) {
        return probableCommaOffset > caretAt;
    }

    private void commitChanges(Project project2, Editor editor, PsiFile psiFile, int caretOffset, @Nullable XmlTag tagToReformat) {
        if (XmlSmartEnterProcessor.isUncommited((Project)project2)) {
            this.commit(editor);
            if (tagToReformat == null) {
                tagToReformat = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getStatementAtCaret(editor, psiFile), XmlTag.class);
            }
            editor.getCaretModel().moveToOffset(caretOffset);
        }
        if (tagToReformat != null) {
            this.reformat((PsiElement)tagToReformat);
        }
        this.commit(editor);
    }

    @Nullable
    private static XmlTag findClosestUnclosedTag(XmlTag tag) {
        XmlTag unclosedTag = tag;
        while (unclosedTag != null) {
            PsiElement lastChild = unclosedTag.getLastChild();
            if (XmlSmartEnterProcessor.isTagUnclosed(lastChild)) {
                return unclosedTag;
            }
            XmlTag prevTag = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)unclosedTag, XmlTag.class);
            unclosedTag = prevTag != null ? prevTag : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)unclosedTag, XmlTag.class);
        }
        return null;
    }

    protected static boolean isTagUnclosed(PsiElement lastChild) {
        return lastChild != null && lastChild.getNode().getElementType() != XmlTokenType.XML_TAG_END && lastChild.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END;
    }

    protected boolean shouldInsertClosingTag(XmlAttribute xmlAttribute, XmlTag tagAtCaret) {
        return xmlAttribute == null || XmlSmartEnterProcessor.getClosingQuote(xmlAttribute).length() != 0;
    }

    protected String getClosingPart(XmlAttribute xmlAttribute, XmlTag tagAtCaret, boolean emptyTag) {
        return XmlSmartEnterProcessor.getClosingQuote(xmlAttribute) + (emptyTag ? "/>" : ">");
    }

    @NotNull
    protected static CharSequence getClosingQuote(@Nullable XmlAttribute attribute) {
        if (attribute == null) {
            return "";
        }
        XmlAttributeValue element = attribute.getValueElement();
        if (element == null) {
            return "";
        }
        String s = element.getText();
        if (s != null && s.length() > 0) {
            if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) != '\"') {
                return "\"";
            }
            if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) != '\'') {
                return "'";
            }
        }
        return "";
    }
}

