/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> IN_TYPE_ARGS = PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.TypeArgumentCompletionProvider");
    private final boolean mySmart;
    @Nullable
    private final InheritorsHolder myInheritors;

    TypeArgumentCompletionProvider(boolean smart, @Nullable InheritorsHolder inheritors) {
        this.mySmart = smart;
        this.myInheritors = inheritors;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
        ExpectedTypeInfo[] types;
        PsiElement context = parameters.getPosition();
        Pair<PsiClass, Integer> pair = TypeArgumentCompletionProvider.getTypeParameterInfo(context);
        if (pair == null) {
            return;
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        if (expression != null && (types = ExpectedTypesProvider.getExpectedTypes(expression, true, false, false)).length > 0) {
            for (ExpectedTypeInfo info : types) {
                PsiType type = info.getType();
                if (!(type instanceof PsiClassType) || type.equals(expression.getType())) continue;
                this.fillExpectedTypeArgs(resultSet, context, (PsiClass)pair.first, (Integer)pair.second, ((PsiClassType)type).resolveGenerics(), this.mySmart ? info.getTailType() : TailType.NONE);
            }
            return;
        }
        if (this.mySmart) {
            TypeArgumentCompletionProvider.addInheritors(parameters, resultSet, (PsiClass)pair.first, (Integer)pair.second);
        }
    }

    private void fillExpectedTypeArgs(CompletionResultSet resultSet, PsiElement context, PsiClass actualClass, int index, PsiClassType.ClassResolveResult expectedType, TailType globalTail) {
        PsiClass expectedClass = expectedType.getElement();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)expectedClass, (boolean)true)) {
            return;
        }
        PsiSubstitutor currentSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)expectedClass, (PsiClass)actualClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        assert (currentSubstitutor != null);
        PsiTypeParameter[] params = actualClass.getTypeParameters();
        ArrayList<PsiTypeLookupItem> typeItems = new ArrayList<PsiTypeLookupItem>();
        for (int i = index; i < params.length; ++i) {
            PsiType arg = TypeArgumentCompletionProvider.getExpectedTypeArg(context, i, expectedType, currentSubstitutor, params);
            if (arg == null) {
                arg = TypeArgumentCompletionProvider.getExpectedTypeArg(context, index, expectedType, currentSubstitutor, params);
                if (arg != null) {
                    resultSet.addElement(TailTypeDecorator.withTail(PsiTypeLookupItem.createLookupItem(arg, context), TypeArgumentCompletionProvider.getTail(index == params.length - 1)));
                }
                return;
            }
            typeItems.add(PsiTypeLookupItem.createLookupItem(arg, context));
        }
        boolean hasParameters = ConstructorInsertHandler.hasConstructorParameters(actualClass, context);
        TypeArgsLookupElement element = new TypeArgsLookupElement(typeItems, globalTail, hasParameters);
        element.registerSingleClass(this.myInheritors);
        resultSet.addElement((LookupElement)element);
    }

    @Nullable
    private static PsiType getExpectedTypeArg(PsiElement context, int index, PsiClassType.ClassResolveResult expectedType, PsiSubstitutor currentSubstitutor, PsiTypeParameter[] params) {
        PsiClass expectedClass = expectedType.getElement();
        assert (expectedClass != null);
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)expectedClass)) {
            PsiType argSubstitution = expectedType.getSubstitutor().substitute(parameter);
            PsiType paramSubstitution = currentSubstitutor.substitute(parameter);
            PsiType substitution = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper().getSubstitutionForTypeParameter(params[index], paramSubstitution, argSubstitution, false, PsiUtil.getLanguageLevel((PsiElement)context));
            if (substitution == null || substitution == PsiType.NULL) continue;
            return substitution;
        }
        return null;
    }

    private static void addInheritors(CompletionParameters parameters, final CompletionResultSet resultSet, final PsiClass referencedClass, final int parameterIndex) {
        List<PsiClassType> typeList = Collections.singletonList((PsiClassType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)referencedClass.getTypeParameters()[parameterIndex]));
        JavaInheritorsGetter.processInheritors(parameters, typeList, resultSet.getPrefixMatcher(), new Consumer<PsiType>(){

            public void consume(PsiType type) {
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                if (psiClass == null) {
                    return;
                }
                resultSet.addElement(TailTypeDecorator.withTail(new JavaPsiClassReferenceElement(psiClass), TypeArgumentCompletionProvider.getTail(parameterIndex == referencedClass.getTypeParameters().length - 1)));
            }
        });
    }

    private static TailType getTail(boolean last) {
        return last ? new CharTailType('>') : TailType.COMMA;
    }

    @Nullable
    static Pair<PsiClass, Integer> getTypeParameterInfo(PsiElement context) {
        int parameterIndex;
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.getContextOfType((PsiElement)context, PsiReferenceParameterList.class, (boolean)true);
        if (parameterList == null) {
            return null;
        }
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        int index = 0;
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getContextOfType((PsiElement)context, PsiTypeElement.class, (boolean)true);
        if (typeElement != null) {
            PsiTypeElement element;
            PsiTypeElement[] elements = referenceElement.getParameterList().getTypeParameterElements();
            while (index < elements.length && (element = elements[index++]) != typeElement) {
            }
        }
        if ((parameterIndex = index - 1) < 0) {
            return null;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass)) {
            return null;
        }
        PsiClass referencedClass = (PsiClass)target;
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length <= parameterIndex) {
            return null;
        }
        return Pair.create((Object)referencedClass, (Object)parameterIndex);
    }

    public static class TypeArgsLookupElement
    extends LookupElement {
        private final String myLookupString;
        private final List<PsiTypeLookupItem> myTypeItems;
        private final TailType myGlobalTail;
        private final boolean myHasParameters;

        public TypeArgsLookupElement(List<PsiTypeLookupItem> typeItems, TailType globalTail, boolean hasParameters) {
            this.myTypeItems = typeItems;
            this.myGlobalTail = globalTail;
            this.myHasParameters = hasParameters;
            this.myLookupString = StringUtil.join(this.myTypeItems, (Function)new Function<PsiTypeLookupItem, String>(){

                public String fun(PsiTypeLookupItem item) {
                    return item.getType().getPresentableText();
                }
            }, (String)", ");
        }

        @NotNull
        public Object getObject() {
            return this.myTypeItems.get(0).getObject();
        }

        public void registerSingleClass(@Nullable InheritorsHolder inheritors) {
            PsiType type;
            PsiClass aClass;
            if (inheritors != null && this.myTypeItems.size() == 1 && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(type = this.myTypeItems.get(0).getType()))) != null && !aClass.hasTypeParameters()) {
                this.myTypeItems.get(0).setShowPackage();
                inheritors.registerClass(aClass);
            }
        }

        @NotNull
        public String getLookupString() {
            return this.myLookupString;
        }

        public void renderElement(LookupElementPresentation presentation) {
            this.myTypeItems.get(0).renderElement(presentation);
            presentation.setItemText(this.getLookupString());
            if (this.myTypeItems.size() > 1) {
                presentation.setTailText(null);
                presentation.setTypeText(null);
            }
        }

        public void handleInsert(InsertionContext context) {
            PsiTypeElement[] typeElements;
            context.commitDocument();
            PsiReferenceParameterList list = (PsiReferenceParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiReferenceParameterList.class, (boolean)false);
            PsiTypeElement[] psiTypeElementArray = typeElements = list != null ? list.getTypeParameterElements() : PsiTypeElement.EMPTY_ARRAY;
            if (typeElements.length == 0) {
                return;
            }
            int listEnd = typeElements[typeElements.length - 1].getTextRange().getEndOffset();
            context.setTailOffset(listEnd);
            context.getDocument().deleteString(context.getStartOffset(), listEnd);
            for (int i = 0; i < this.myTypeItems.size(); ++i) {
                PsiTypeLookupItem typeItem = this.myTypeItems.get(i);
                CompletionUtil.emulateInsertion(context, context.getTailOffset(), (LookupElement)typeItem);
                if (context.getTailOffset() < 0) {
                    LOG.error("tail offset spoiled by " + typeItem);
                    return;
                }
                context.setTailOffset(TypeArgumentCompletionProvider.getTail(i == this.myTypeItems.size() - 1).processTail(context.getEditor(), context.getTailOffset()));
            }
            context.setAddCompletionChar(false);
            context.commitDocument();
            PsiElement leaf = context.getFile().findElementAt(context.getTailOffset() - 1);
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiNewExpression.class})).accepts((Object)leaf)) {
                ParenthesesInsertHandler.getInstance((boolean)this.myHasParameters).handleInsert(context, (LookupElement)this);
                this.myGlobalTail.processTail(context.getEditor(), context.getTailOffset());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TypeArgsLookupElement element = (TypeArgsLookupElement)((Object)o);
            return this.myTypeItems.equals(element.myTypeItems);
        }

        public int hashCode() {
            return this.myTypeItems.hashCode();
        }
    }
}

