/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FlatteningIterator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.StatisticsWeigher.LookupStatisticsWeigher");
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create((String)"Base statistics info");

    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item);
        if (info == null) {
            if (location == null) {
                return StatisticsInfo.EMPTY;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
        }
        return info;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        return (info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)item, (Object)location)) == null ? StatisticsInfo.EMPTY : info;
    }

    public static StatisticsInfo composeStatsWithPrefix(StatisticsInfo info, String fullPrefix, boolean forWriting) {
        ArrayList<StatisticsInfo> infos = new ArrayList<StatisticsInfo>((fullPrefix.length() + 3) * info.getConjuncts().size());
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            if (forWriting) {
                infos.add(conjunct);
            }
            for (int i = 0; i <= fullPrefix.length(); ++i) {
                infos.add(StatisticsWeigher.composeWithPrefix(conjunct, fullPrefix.substring(0, i), forWriting));
            }
            infos.add(StatisticsWeigher.composeWithPrefix(conjunct, fullPrefix, !forWriting));
        }
        return StatisticsInfo.createComposite(infos);
    }

    private static StatisticsInfo composeWithPrefix(StatisticsInfo info, String fullPrefix, boolean partial) {
        return new StatisticsInfo(info.getContext() + "###prefix=" + fullPrefix + "###part#" + partial, info.getValue());
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights = ContainerUtil.newIdentityHashMap();
        private final Set<LookupElement> myNoStats = ContainerUtil.newIdentityTroveSet();
        private int myPrefixChanges;

        public LookupStatisticsWeigher(CompletionLocation location, Classifier<LookupElement> next) {
            super(next, "stats");
            this.myLocation = location;
        }

        @Override
        public void addElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            StatisticsInfo baseInfo = StatisticsWeigher.getBaseStatisticsInfo(element, this.myLocation);
            this.myWeights.put(element, new StatisticsComparable(LookupStatisticsWeigher.weigh(element, baseInfo, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT)), baseInfo));
            if (baseInfo == StatisticsInfo.EMPTY) {
                this.myNoStats.add(element);
            }
            super.addElement(element, context);
        }

        private void checkPrefixChanged(ProcessingContext context) {
            int actualPrefixChanges = (Integer)context.get(CompletionLookupArranger.PREFIX_CHANGES);
            if (this.myPrefixChanges != actualPrefixChanges) {
                this.myPrefixChanges = actualPrefixChanges;
                this.myWeights.clear();
            }
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context) {
            this.checkPrefixChanged(context);
            final Collection byWeight = this.buildMapByWeight(source, context).descendingMap().values();
            List<LookupElement> initialList = this.getInitialNoStatElements(source, context);
            final THashSet initialSet = new THashSet(initialList, TObjectHashingStrategy.IDENTITY);
            Condition<LookupElement> notInInitialList = new Condition<LookupElement>(){

                public boolean value(LookupElement element) {
                    return !initialSet.contains((Object)element);
                }
            };
            return ContainerUtil.concat((Iterable[])new Iterable[]{initialList, new Iterable<LookupElement>((Condition)notInInitialList, context){
                final /* synthetic */ Condition val$notInInitialList;
                final /* synthetic */ ProcessingContext val$context;
                {
                    this.val$notInInitialList = condition;
                    this.val$context = processingContext;
                }

                @Override
                public Iterator<LookupElement> iterator() {
                    return new FlatteningIterator<List<LookupElement>, LookupElement>(byWeight.iterator()){

                        protected Iterator<LookupElement> createValueIterator(List<LookupElement> group) {
                            return myNext.classify(ContainerUtil.findAll(group, (Condition)val$notInInitialList), val$context).iterator();
                        }
                    };
                }
            }});
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<LookupElement> source, ProcessingContext context) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement next : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(next)) break;
                initialList.add(next);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<LookupElement> source, ProcessingContext context) {
            TreeMap<Integer, List<LookupElement>> map = new TreeMap<Integer, List<LookupElement>>();
            for (LookupElement element : source) {
                int weight = this.getWeight(element, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT)).getScalar();
                SmartList list = map.get(weight);
                if (list == null) {
                    list = new SmartList();
                    map.put(weight, (List<LookupElement>)list);
                }
                list.add((LookupElement)element);
            }
            return map;
        }

        private StatisticsComparable getWeight(LookupElement t, WeighingContext context) {
            StatisticsComparable w = this.myWeights.get(t);
            if (w == null) {
                StatisticsInfo info = StatisticsWeigher.getBaseStatisticsInfo(t, this.myLocation);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(t, info, context), info);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(@NotNull LookupElement item, StatisticsInfo baseInfo, WeighingContext context) {
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            String prefix = context.itemPattern(item);
            StatisticsInfo composed = StatisticsWeigher.composeStatsWithPrefix(baseInfo, prefix, false);
            int minRecency = composed.getLastUseRecency();
            int useCount = composed.getUseCount();
            return minRecency == Integer.MAX_VALUE ? useCount : 100 - minRecency;
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items, final @NotNull ProcessingContext context) {
            this.checkPrefixChanged(context);
            return ContainerUtil.map(items, (Function)new Function<LookupElement, Pair<LookupElement, Object>>(){

                public Pair<LookupElement, Object> fun(LookupElement lookupElement) {
                    return new Pair((Object)lookupElement, (Object)this.getWeight(lookupElement, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT)));
                }
            });
        }

        @Override
        public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            this.myWeights.remove(element);
            this.myNoStats.remove(element);
            super.removeElement(element, context);
        }
    }
}

