/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartCastProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> TYPECAST_TYPE_CANDIDATE = PlatformPatterns.psiElement().afterLeaf(new String[]{"("});

    SmartCastProvider() {
    }

    static boolean shouldSuggestCast(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = SmartCastProvider.getParenthesisOwner(position);
        if (parent instanceof PsiTypeCastExpression) {
            return true;
        }
        if (parent instanceof PsiParenthesizedExpression) {
            return parameters.getOffset() == position.getTextRange().getStartOffset();
        }
        return false;
    }

    private static PsiElement getParenthesisOwner(PsiElement position) {
        PsiElement lParen = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return lParen == null || !lParen.textMatches((CharSequence)"(") ? null : lParen.getParent();
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        SmartCastProvider.addCastVariants(parameters, (Consumer<LookupElement>)result);
    }

    static void addCastVariants(@NotNull CompletionParameters parameters, @NotNull Consumer<LookupElement> result) {
        PsiElement parent;
        if (!SmartCastProvider.shouldSuggestCast(parameters)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        boolean insideCast = parenthesisOwner instanceof PsiTypeCastExpression;
        if (insideCast && (parent = parenthesisOwner.getParent()) instanceof PsiParenthesizedExpression && parent.getParent() instanceof PsiReferenceExpression) {
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiParenthesizedExpression)parent), false)) {
                result.consume((Object)PsiTypeLookupItem.createLookupItem(info.getType(), parent));
            }
            return;
        }
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiClassType boxedType;
            PsiType castedType;
            PsiType type = info.getDefaultType();
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getBound();
            }
            if (type == null || PsiType.VOID.equals((Object)type)) continue;
            if (type instanceof PsiPrimitiveType && (castedType = SmartCastProvider.getCastedExpressionType(parenthesisOwner)) != null && !(castedType instanceof PsiPrimitiveType) && (boxedType = ((PsiPrimitiveType)type).getBoxedType(position)) != null) {
                type = boxedType;
            }
            result.consume((Object)SmartCastProvider.createSmartCastElement(parameters, insideCast, type));
        }
    }

    @Nullable
    private static PsiType getCastedExpressionType(PsiElement parenthesisOwner) {
        if (parenthesisOwner instanceof PsiTypeCastExpression) {
            PsiExpression operand = ((PsiTypeCastExpression)parenthesisOwner).getOperand();
            return operand == null ? null : operand.getType();
        }
        if (parenthesisOwner instanceof PsiParenthesizedExpression) {
            PsiElement next;
            for (next = parenthesisOwner.getNextSibling(); next != null && (next instanceof PsiEmptyExpressionImpl || next instanceof PsiErrorElement || next instanceof PsiWhiteSpace); next = next.getNextSibling()) {
            }
            if (next instanceof PsiExpression) {
                return ((PsiExpression)next).getType();
            }
        }
        return null;
    }

    private static LookupElement createSmartCastElement(final CompletionParameters parameters, final boolean overwrite, PsiType type) {
        return AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<PsiTypeLookupItem>(PsiTypeLookupItem.createLookupItem(type, parameters.getPosition())){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                if (overwrite) {
                    document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                }
                CommonCodeStyleSettings csSettings = context.getCodeStyleSettings();
                int oldTail = context.getTailOffset();
                context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                ((PsiTypeLookupItem)this.getDelegate()).handleInsert(CompletionUtil.newContext(context, this.getDelegate(), context.getStartOffset(), oldTail));
                PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                if (csSettings.SPACE_AFTER_TYPE_CAST) {
                    context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                }
                if (parameters.getCompletionType() == CompletionType.SMART) {
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }
}

