/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodCallElement
extends LookupItem<PsiMethod>
implements TypedLookupItem,
StaticallyImportable {
    public static final ClassConditionKey<JavaMethodCallElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaMethodCallElement.class);
    @Nullable
    private final PsiClass myContainingClass;
    private final PsiMethod myMethod;
    private final MemberLookupHelper myHelper;
    private PsiSubstitutor myQualifierSubstitutor = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myInferenceSubstitutor = PsiSubstitutor.EMPTY;
    private boolean myMayNeedExplicitTypeParameters;
    private String myForcedQualifier = "";

    public JavaMethodCallElement(@NotNull PsiMethod method) {
        this(method, method.getName());
    }

    public JavaMethodCallElement(@NotNull PsiMethod method, String methodName) {
        super(method, methodName);
        this.myMethod = method;
        this.myHelper = null;
        this.myContainingClass = method.getContainingClass();
    }

    public JavaMethodCallElement(PsiMethod method, boolean shouldImportStatic, boolean mergedOverloads) {
        super(method, method.getName());
        String className;
        this.myMethod = method;
        this.myContainingClass = method.getContainingClass();
        this.myHelper = new MemberLookupHelper((PsiMember)method, this.myContainingClass, shouldImportStatic, mergedOverloads);
        if (!shouldImportStatic && this.myContainingClass != null && (className = this.myContainingClass.getName()) != null) {
            this.addLookupStrings(new String[]{className + "." + this.myMethod.getName()});
        }
    }

    void setForcedQualifier(@NotNull String forcedQualifier) {
        this.myForcedQualifier = forcedQualifier;
        this.setLookupString(forcedQualifier + this.getLookupString());
    }

    @Override
    public PsiType getType() {
        return this.getSubstitutor().substitute(this.getInferenceSubstitutor().substitute(((PsiMethod)this.getObject()).getReturnType()));
    }

    public void setInferenceSubstitutor(@NotNull PsiSubstitutor substitutor, PsiElement place) {
        this.myInferenceSubstitutor = substitutor;
        this.myMayNeedExplicitTypeParameters = JavaMethodCallElement.mayNeedTypeParameters(place);
    }

    public JavaMethodCallElement setQualifierSubstitutor(@NotNull PsiSubstitutor qualifierSubstitutor) {
        this.myQualifierSubstitutor = qualifierSubstitutor;
        return this;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return this.myQualifierSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.canBeImported() && this.myHelper.willBeImported();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodCallElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.myInferenceSubstitutor.equals(((JavaMethodCallElement)o).myInferenceSubstitutor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myInferenceSubstitutor.hashCode();
        return result;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        Document document = context.getDocument();
        PsiFile file2 = context.getFile();
        PsiMethod method = (PsiMethod)this.getObject();
        LookupElement[] allItems = context.getElements();
        boolean overloadsMatter = allItems.length == 1 && this.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) == null;
        boolean hasParams = MethodParenthesesHandler.hasParams((LookupElement)this, (LookupElement[])allItems, (boolean)overloadsMatter, (PsiMethod)method);
        JavaCompletionUtil.insertParentheses(context, (LookupElement)this, overloadsMatter, hasParams);
        int startOffset = context.getStartOffset();
        OffsetKey refStart = context.trackOffset(startOffset, true);
        if (this.shouldInsertTypeParameters() && JavaMethodCallElement.mayNeedTypeParameters(context.getFile().findElementAt(context.getStartOffset()))) {
            this.qualifyMethodCall(file2, startOffset, document);
            this.insertExplicitTypeParameters(context, refStart);
        } else if (this.myHelper != null) {
            context.commitDocument();
            if (this.willBeImported()) {
                PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)startOffset, PsiReferenceExpression.class, (boolean)false);
                if (ref != null && this.myContainingClass != null && !ref.isReferenceTo((PsiElement)method)) {
                    ref.bindToElementViaStaticImport(this.myContainingClass);
                }
                return;
            }
            this.qualifyMethodCall(file2, startOffset, document);
        }
        PsiType type = method.getReturnType();
        if (context.getCompletionChar() == '!' && type != null && PsiType.BOOLEAN.isAssignableFrom(type)) {
            context.setAddCompletionChar(false);
            context.commitDocument();
            int offset = context.getOffset(refStart);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(methodCall.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
    }

    private boolean shouldInsertTypeParameters() {
        return this.myMayNeedExplicitTypeParameters && !this.getInferenceSubstitutor().equals(PsiSubstitutor.EMPTY) && this.myMethod.getParameterList().getParametersCount() == 0;
    }

    public static boolean mayNeedTypeParameters(@Nullable PsiElement leaf) {
        if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiConditionalExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null) {
            return false;
        }
        if (PsiUtil.getLanguageLevel((PsiElement)leaf).isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiElement parent = leaf.getParent();
        return !(parent instanceof PsiReferenceExpression) || ((PsiReferenceExpression)parent).getTypeParameters().length <= 0;
    }

    private void insertExplicitTypeParameters(InsertionContext context, OffsetKey refStart) {
        context.commitDocument();
        String typeParams = this.getTypeParamsText(false);
        if (typeParams != null) {
            context.getDocument().insertString(context.getOffset(refStart), (CharSequence)typeParams);
            JavaCompletionUtil.shortenReference(context.getFile(), context.getOffset(refStart));
        }
    }

    private void qualifyMethodCall(PsiFile file2, int startOffset, Document document) {
        PsiReference reference = file2.findReferenceAt(startOffset);
        if (reference instanceof PsiReferenceExpression && ((PsiReferenceExpression)reference).isQualified()) {
            return;
        }
        PsiMethod method = (PsiMethod)this.getObject();
        if (!method.hasModifierProperty("static")) {
            document.insertString(startOffset, (CharSequence)"this.");
            return;
        }
        if (this.myContainingClass == null) {
            return;
        }
        document.insertString(startOffset, (CharSequence)".");
        JavaCompletionUtil.insertClassReference(this.myContainingClass, file2, startOffset);
    }

    @Nullable
    private String getTypeParamsText(boolean presentable) {
        PsiMethod method = (PsiMethod)this.getObject();
        PsiSubstitutor substitutor = this.getInferenceSubstitutor();
        PsiTypeParameter[] parameters = method.getTypeParameters();
        assert (parameters.length > 0);
        StringBuilder builder = new StringBuilder("<");
        boolean first = true;
        for (PsiTypeParameter parameter : parameters) {
            String text;
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PsiType type = substitutor.substitute(parameter);
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getExtendsBound();
            }
            if (type == null || type instanceof PsiCapturedWildcardType) {
                return null;
            }
            if (type.equals(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter))) {
                return null;
            }
            String string = text = presentable ? type.getPresentableText() : type.getCanonicalText();
            if (text.indexOf(63) >= 0) {
                return null;
            }
            builder.append(text);
        }
        return builder.append(">").toString();
    }

    public boolean isValid() {
        return super.isValid() && this.myInferenceSubstitutor.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        String typeParamsText;
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)this));
        MemberLookupHelper helper = this.myHelper != null ? this.myHelper : new MemberLookupHelper((PsiMember)this.myMethod, this.myContainingClass, false, false);
        helper.renderElement(presentation, this.myHelper != null, this.myHelper != null && !this.myHelper.willBeImported(), this.getSubstitutor());
        if (!this.myForcedQualifier.isEmpty()) {
            presentation.setItemText(this.myForcedQualifier + presentation.getItemText());
        }
        if (this.shouldInsertTypeParameters() && (typeParamsText = this.getTypeParamsText(true)) != null) {
            if (typeParamsText.length() > 10) {
                typeParamsText = typeParamsText.substring(0, 10) + "...>";
            }
            String itemText = presentation.getItemText();
            assert (itemText != null);
            int i = itemText.indexOf(46);
            if (i > 0) {
                presentation.setItemText(itemText.substring(0, i + 1) + typeParamsText + itemText.substring(i + 1));
            }
        }
    }
}

