/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

class JavaClassNameInsertHandler
implements InsertHandler<JavaPsiClassReferenceElement> {
    static final InsertHandler<JavaPsiClassReferenceElement> JAVA_CLASS_INSERT_HANDLER = new JavaClassNameInsertHandler();

    JavaClassNameInsertHandler() {
    }

    public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
        boolean fillTypeArgs;
        int offset = context.getTailOffset() - 1;
        PsiFile file2 = context.getFile();
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiImportStatementBase.class, (boolean)false) != null) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
            String qname = item.getQualifiedName();
            if (!(qname == null || ref != null && qname.equals(ref.getCanonicalText()))) {
                AllClassesGetter.INSERT_FQN.handleInsert(context, (LookupElement)item);
            }
            return;
        }
        PsiElement position = file2.findElementAt(offset);
        PsiJavaCodeReferenceElement ref = position != null && position.getParent() instanceof PsiJavaCodeReferenceElement ? (PsiJavaCodeReferenceElement)position.getParent() : null;
        PsiClass psiClass = item.getObject();
        Project project2 = context.getProject();
        Editor editor = context.getEditor();
        char c = context.getCompletionChar();
        if (c == '#') {
            context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(project2, editor));
        } else if (c == '.' && PsiTreeUtil.getParentOfType((PsiElement)position, PsiParameterList.class) == null) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
        String qname = psiClass.getQualifiedName();
        if (qname != null && PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class, (boolean)false) != null && JavaClassNameInsertHandler.shouldInsertFqnInJavadoc(item, file2, project2)) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)qname);
            return;
        }
        if (ref != null && PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocTag.class) != null && ref.isReferenceTo((PsiElement)psiClass)) {
            return;
        }
        OffsetKey refEnd = context.trackOffset(context.getTailOffset(), false);
        boolean bl = fillTypeArgs = context.getCompletionChar() == '<';
        if (fillTypeArgs) {
            context.setAddCompletionChar(false);
        }
        if (ref == null || !ref.isQualified()) {
            PsiTypeLookupItem.addImportForItem(context, psiClass);
        }
        if (context.getOffset(refEnd) < 0) {
            return;
        }
        context.setTailOffset(context.getOffset(refEnd));
        context.commitDocument();
        if (item.getUserData(JavaChainLookupElement.CHAIN_QUALIFIER) == null && JavaClassNameInsertHandler.shouldInsertParentheses(file2.findElementAt(context.getTailOffset() - 1))) {
            if (ConstructorInsertHandler.insertParentheses(context, (LookupElement)item, psiClass, false)) {
                fillTypeArgs |= psiClass.hasTypeParameters() && PsiUtil.getLanguageLevel((PsiElement)file2).isAtLeast(LanguageLevel.JDK_1_5);
            }
        } else if (JavaClassNameInsertHandler.insertingAnnotation(context, (LookupElement)item)) {
            if (JavaClassNameInsertHandler.shouldHaveAnnotationParameters(psiClass)) {
                JavaCompletionUtil.insertParentheses(context, (LookupElement)item, false, true);
            }
            if (context.getCompletionChar() == '\n' || context.getCompletionChar() == '\r') {
                CharSequence text = context.getDocument().getCharsSequence();
                int tail = context.getTailOffset();
                if (text.length() > tail && Character.isLetter(text.charAt(tail))) {
                    context.getDocument().insertString(tail, (CharSequence)" ");
                }
            }
        }
        if (fillTypeArgs && context.getCompletionChar() != '(') {
            JavaCompletionUtil.promptTypeArgs(context, context.getOffset(refEnd));
        }
    }

    private static boolean shouldInsertFqnInJavadoc(@NotNull JavaPsiClassReferenceElement item, @NotNull PsiFile file2, @NotNull Project project2) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        switch (javaSettings.CLASS_NAMES_IN_JAVADOC) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 1: {
                if (!(file2 instanceof PsiJavaFile)) break;
                PsiJavaFile javaFile = (PsiJavaFile)file2;
                return item.getQualifiedName() != null && !ImportHelper.isAlreadyImported(javaFile, item.getQualifiedName());
            }
        }
        return false;
    }

    private static boolean shouldInsertParentheses(PsiElement position) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiJavaCodeReferenceElement.class);
        if (ref == null) {
            return false;
        }
        PsiReferenceParameterList parameterList = ref.getParameterList();
        if (parameterList != null && parameterList.getTextLength() > 0) {
            return false;
        }
        PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)ref);
        if (prevElement != null && prevElement.getParent() instanceof PsiNewExpression) {
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)prevElement.getParent(), true)) {
                if (!(info.getType() instanceof PsiArrayType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean insertingAnnotation(InsertionContext context, LookupElement item) {
        Object obj = item.getObject();
        if (!(obj instanceof PsiClass) || !((PsiClass)obj).isAnnotationType()) {
            return false;
        }
        PsiElement leaf = context.getFile().findElementAt(context.getStartOffset());
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)leaf);
    }

    static boolean shouldHaveAnnotationParameters(PsiClass annoClass) {
        for (PsiMethod m : annoClass.getMethods()) {
            if (!PsiUtil.isAnnotationMethod((PsiElement)m) || ((PsiAnnotationMethod)m).getDefaultValue() != null) continue;
            return true;
        }
        return false;
    }
}

