/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritorsHolder
implements Consumer<LookupElement> {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private final CompletionResultSet myResult;

    public InheritorsHolder(CompletionResultSet result) {
        this.myResult = result;
    }

    public void consume(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            this.registerClass((PsiClass)object);
        }
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)InheritorsHolder.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        String name = psiClass.getQualifiedName();
        return name == null ? psiClass.getName() : name;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        Object object = element.getObject();
        return object instanceof PsiClass && this.alreadyProcessed((PsiClass)object);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        String name = InheritorsHolder.getClassName(object);
        return name == null || this.myAddedClasses.contains(name);
    }
}

