/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultCompletionContributor
extends CompletionContributor {
    static void addDefaultAdvertisements(@NotNull CompletionParameters parameters, LookupImpl lookup, boolean includePsiFeatures) {
        String shortcut;
        if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishByDotEtc")) {
            lookup.addAdvertisement(LangBundle.message("completion.dot.etc.ad", new Object[0]), null);
        }
        if (!includePsiFeatures) {
            return;
        }
        if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishBySmartEnter") && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"EditorChooseLookupItemCompleteStatement")))) {
            lookup.addAdvertisement(LangBundle.message("completion.smart.enter.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(parameters, "codeassists.quickjavadoc") || CompletionUtil.shouldShowFeature(parameters, "codeassists.quickjavadoc.lookup")) && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickJavaDoc")))) {
            lookup.addAdvertisement(LangBundle.message("completion.quick.javadoc.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(parameters, "codeassists.quickdefinition") || CompletionUtil.shouldShowFeature(parameters, "codeassists.quickdefinition.lookup")) && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickImplementations")))) {
            lookup.addAdvertisement(LangBundle.message("completion.quick.implementations.ad", shortcut), null);
        }
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        return LangBundle.message("completion.no.suggestions", new Object[0]);
    }

    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        LookupElement[] items = context.getItems();
        if (items.length == 1) {
            LookupElement item = items[0];
            if (!StringUtil.isEmpty((String)context.getLookup().itemPattern(item)) || context.getParameters().getCompletionType() == CompletionType.SMART) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
        }
        return null;
    }
}

