/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionUtilCoreImpl {
    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        return CompletionUtilCoreImpl.getOriginalElement(psi, psi.getContainingFile());
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi, PsiFile containingFile) {
        if (containingFile == null) {
            return psi;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        if (originalFile != containingFile && !(originalFile instanceof PsiCompiledFile) && psi.getTextRange() != null) {
            Document hostDocument;
            OffsetTranslator translator;
            TextRange range = psi.getTextRange();
            Integer start = range.getStartOffset();
            Integer end = range.getEndOffset();
            Document document = containingFile.getViewProvider().getDocument();
            if (document != null && (translator = (OffsetTranslator)(hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document).getUserData(OffsetTranslator.RANGE_TRANSLATION)) != null) {
                if (document instanceof DocumentWindow) {
                    TextRange translated = ((DocumentWindow)document).injectedToHost(new TextRange(start.intValue(), end.intValue()));
                    start = translated.getStartOffset();
                    end = translated.getEndOffset();
                }
                start = translator.translateOffset(start);
                end = translator.translateOffset(end);
                if (start == null || end == null) {
                    return null;
                }
                if (document instanceof DocumentWindow) {
                    start = ((DocumentWindow)document).hostToInjected(start.intValue());
                    end = ((DocumentWindow)document).hostToInjected(end.intValue());
                }
            }
            return (T)PsiTreeUtil.findElementOfClassAtRange((PsiFile)originalFile, (int)start, (int)end, psi.getClass());
        }
        return psi;
    }
}

