/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionTemplateItem;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.KeywordLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInsight.template.SmartCompletionContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.getters.ClassLiteralGetter;
import com.intellij.psi.filters.getters.ThisGetter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicExpressionCompletionContributor {
    private static void addKeyword(Consumer<LookupElement> result, PsiElement element, String s) {
        result.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(element, s));
    }

    public static LookupElement createKeywordLookupItem(PsiElement element, String s) {
        return new KeywordLookupItem(JavaPsiFacade.getElementFactory((Project)element.getProject()).createKeyword(s, element), element);
    }

    public static void fillCompletionVariants(JavaSmartCompletionParameters parameters, Consumer<LookupElement> result, PrefixMatcher matcher) {
        PsiElement element = parameters.getPosition();
        if (JavaKeywordCompletion.isAfterTypeDot(element)) {
            BasicExpressionCompletionContributor.addKeyword(result, element, "class");
            BasicExpressionCompletionContributor.addKeyword(result, element, "this");
        }
        if (!JavaKeywordCompletion.AFTER_DOT.accepts((Object)element)) {
            if (parameters.getParameters().getInvocationCount() <= 1) {
                new CollectionsUtilityMethodsProvider(parameters.getPosition(), parameters.getExpectedType(), parameters.getDefaultType(), result).addCompletions(StringUtil.isNotEmpty((String)matcher.getPrefix()));
            }
            ClassLiteralGetter.addCompletions(parameters, result, matcher);
            PsiElement position = parameters.getPosition();
            PsiType expectedType = parameters.getExpectedType();
            for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
                if (template.isDeactivated() || !template.getTemplateContext().isEnabled(new SmartCompletionContextType())) continue;
                result.consume((Object)new SmartCompletionTemplateItem(template, position));
            }
            BasicExpressionCompletionContributor.addKeyword(result, position, "true");
            BasicExpressionCompletionContributor.addKeyword(result, position, "false");
            PsiElement parent = position.getParent();
            if (parent != null && !(parent.getParent() instanceof PsiSwitchLabelStatement)) {
                for (PsiExpression expression : ThisGetter.getThisExpressionVariants(position)) {
                    result.consume((Object)new ExpressionLookupItem(expression));
                }
            }
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(position, expectedType, matcher, result);
        }
    }

    public static void processDataflowExpressionTypes(PsiElement position, @Nullable PsiType expectedType, final PrefixMatcher matcher, Consumer<LookupElement> consumer) {
        PsiExpression context = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpression.class);
        if (context == null) {
            return;
        }
        final Map<PsiExpression, PsiType> map = GuessManager.getInstance(position.getProject()).getControlFlowExpressionTypes(context);
        if (map.isEmpty()) {
            return;
        }
        PsiScopesUtil.treeWalkUp(new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element instanceof PsiLocalVariable) {
                    PsiType dfaCasted;
                    PsiTypeCastExpression typeCastExpression;
                    PsiExpression operand;
                    if (!matcher.prefixMatches(((PsiLocalVariable)element).getName())) {
                        return true;
                    }
                    PsiExpression expression = ((PsiLocalVariable)element).getInitializer();
                    if (expression instanceof PsiTypeCastExpression && (operand = (typeCastExpression = (PsiTypeCastExpression)expression).getOperand()) != null && (dfaCasted = (PsiType)map.get(operand)) != null && dfaCasted.equals(typeCastExpression.getType())) {
                        map.remove(operand);
                    }
                }
                return true;
            }
        }, (PsiElement)context, (PsiElement)context.getContainingFile());
        for (PsiExpression expression : map.keySet()) {
            PsiType castType = map.get(expression);
            PsiType baseType = expression.getType();
            if (expectedType != null && (!expectedType.isAssignableFrom(castType) || baseType != null && expectedType.isAssignableFrom(baseType))) continue;
            consumer.consume((Object)CastingLookupElementDecorator.createCastingElement(BasicExpressionCompletionContributor.expressionToLookupElement(expression), castType));
        }
    }

    @NotNull
    private static LookupElement expressionToLookupElement(@NotNull PsiExpression expression) {
        PsiMethod method;
        PsiMethodCallExpression call;
        PsiElement target;
        PsiReferenceExpression refExpr;
        if (expression instanceof PsiReferenceExpression && !(refExpr = (PsiReferenceExpression)expression).isQualified() && (target = refExpr.resolve()) instanceof PsiVariable) {
            VariableLookupItem item = new VariableLookupItem((PsiVariable)target);
            item.setSubstitutor(PsiSubstitutor.EMPTY);
            return item;
        }
        if (expression instanceof PsiMethodCallExpression && !(call = (PsiMethodCallExpression)expression).getMethodExpression().isQualified() && (method = call.resolveMethod()) != null) {
            return new JavaMethodCallElement(method);
        }
        return new ExpressionLookupItem(expression);
    }
}

