/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;

public class AddSpaceInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new AddSpaceInsertHandler(false);
    public static final InsertHandler<LookupElement> INSTANCE_WITH_AUTO_POPUP = new AddSpaceInsertHandler(true);
    private final boolean myTriggerAutoPopup;

    public AddSpaceInsertHandler(boolean triggerAutoPopup) {
        this.myTriggerAutoPopup = triggerAutoPopup;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Editor editor = context.getEditor();
        if (context.getCompletionChar() == ' ') {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 != null) {
            if (!AddSpaceInsertHandler.isCharAtSpace(editor)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            } else {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            }
            if (this.myTriggerAutoPopup) {
                AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, null);
            }
        }
    }

    private static boolean isCharAtSpace(Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ' ';
    }
}

