/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    private final Collection<TextRange> myRanges = new ArrayList<TextRange>();
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project2, boolean processChangedTextOnly) {
        super(project2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, Module module2, boolean processChangedTextOnly) {
        super(project2, module2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project2, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile file2, @Nullable TextRange range, boolean processChangedTextOnly) {
        super(project2, file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        if (range != null) {
            this.myRanges.add(range);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project2, files, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file2, final boolean processChangedTextOnly) throws IncorrectOperationException {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
                try {
                    Collection ranges = ReformatCodeProcessor.this.getRangesToFormat(processChangedTextOnly, file2);
                    CharSequence before = null;
                    Document document = PsiDocumentManager.getInstance((Project)ReformatCodeProcessor.this.myProject).getDocument(file2);
                    if (ReformatCodeProcessor.this.getInfoCollector() != null) {
                        LOG.assertTrue(document != null);
                        before = document.getImmutableCharSequence();
                    }
                    CaretVisualPositionKeeper caretPositionKeeper = new CaretVisualPositionKeeper(document);
                    if (processChangedTextOnly) {
                        CodeStyleManager.getInstance((Project)ReformatCodeProcessor.this.myProject).reformatTextWithContext(file2, ranges);
                    } else {
                        CodeStyleManager.getInstance((Project)ReformatCodeProcessor.this.myProject).reformatText(file2, ranges);
                    }
                    caretPositionKeeper.restoreOriginalLocation();
                    if (before != null) {
                        ReformatCodeProcessor.this.prepareUserNotificationMessage(document, before);
                    }
                    Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                    return bl;
                }
                catch (FilesTooBigForDiffException e) {
                    ReformatCodeProcessor.this.handleFileTooBigException(LOG, e, file2);
                    Boolean bl = false;
                    return bl;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    ReformatCodeProcessor.this.myRanges.clear();
                }
            }
        });
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(boolean processChangedTextOnly, PsiFile file2) throws FilesTooBigForDiffException {
        if (this.mySelectionModel != null) {
            return ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
    }

    private static class CaretVisualPositionKeeper {
        private final Map<Editor, Integer> myCaretRelativeVerticalPositions = new HashMap<Editor, Integer>();

        private CaretVisualPositionKeeper(@Nullable Document document) {
            Editor[] editors;
            if (document == null) {
                return;
            }
            for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
                Point pos = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
                int relativePosition = pos.y - visibleArea.y;
                this.myCaretRelativeVerticalPositions.put(editor, relativePosition);
            }
        }

        private void restoreOriginalLocation() {
            for (Map.Entry<Editor, Integer> e : this.myCaretRelativeVerticalPositions.entrySet()) {
                Editor editor = e.getKey();
                int relativePosition = e.getValue();
                Point caretLocation = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
                int scrollOffset = caretLocation.y - relativePosition;
                editor.getScrollingModel().disableAnimation();
                editor.getScrollingModel().scrollVertically(scrollOffset);
                editor.getScrollingModel().enableAnimation();
            }
        }
    }
}

