/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"process.rearrange.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance(RearrangeCodeProcessor.class);
    private SelectionModel mySelectionModel;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
    }

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public RearrangeCodeProcessor(@NotNull Project project2, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file2, final boolean processChangedTextOnly) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    Collection<TextRange> ranges = RearrangeCodeProcessor.this.getRangesToFormat(file2, processChangedTextOnly);
                    Document document = PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).getDocument(file2);
                    if (document != null && Rearranger.EXTENSION.forLanguage(file2.getLanguage()) != null) {
                        PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).doPostponedOperationsAndUnblockDocument(document);
                        PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).commitDocument(document);
                        Runnable command = RearrangeCodeProcessor.this.prepareRearrangeCommand(file2, ranges);
                        try {
                            CommandProcessor.getInstance().executeCommand(RearrangeCodeProcessor.this.myProject, command, RearrangeCodeProcessor.COMMAND_NAME, null);
                        }
                        finally {
                            PsiDocumentManager.getInstance((Project)RearrangeCodeProcessor.this.myProject).commitDocument(document);
                        }
                    }
                    return true;
                }
                catch (FilesTooBigForDiffException e) {
                    RearrangeCodeProcessor.this.handleFileTooBigException(LOG, e, file2);
                    return false;
                }
            }
        });
    }

    @NotNull
    private Runnable prepareRearrangeCommand(final @NotNull PsiFile file2, final @NotNull Collection<TextRange> ranges) {
        final ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myProject, ArrangementEngine.class);
        return new Runnable(){

            @Override
            public void run() {
                engine.arrange(file2, ranges);
                if (RearrangeCodeProcessor.this.getInfoCollector() != null) {
                    String info = engine.getUserNotificationInfo();
                    RearrangeCodeProcessor.this.getInfoCollector().setRearrangeCodeNotification(info);
                }
            }
        };
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file2, boolean processChangedTextOnly) throws FilesTooBigForDiffException {
        if (this.mySelectionModel != null) {
            return RearrangeCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return ContainerUtil.newSmartList((Object)file2.getTextRange());
    }
}

