/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormatChangedTextUtil {
    public static final Key<CharSequence> TEST_REVISION_CONTENT = Key.create((String)"test.revision.content");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    protected FormatChangedTextUtil() {
    }

    @NotNull
    public static FormatChangedTextUtil getInstance() {
        return (FormatChangedTextUtil)ServiceManager.getService(FormatChangedTextUtil.class);
    }

    public static boolean hasChanges(@NotNull PsiFile file2) {
        Project project2 = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project2).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file2, @NotNull Project project2) {
        Collection changes = ChangeListManager.getInstance((Project)project2).getChangesIn(file2);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files, @NotNull Project project2) {
        for (VirtualFile file2 : files) {
            if (!FormatChangedTextUtil.hasChanges(file2, project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module2) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module2.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(final @NotNull Project project2) {
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(@NotNull Result<ModifiableModuleModel> result) throws Throwable {
                result.setResult((Object)ModuleManager.getInstance((Project)project2).getModifiableModel());
            }
        }.execute().getResultObject();
        try {
            for (Module module2 : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project2, @NotNull List<PsiDirectory> dirs) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        ArrayList changes = ContainerUtil.newArrayList();
        for (PsiDirectory dir : dirs) {
            changes.addAll(changeListManager.getChangesIn(dir.getVirtualFile()));
        }
        return FormatChangedTextUtil.getChangedFiles(project2, changes);
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(final @NotNull Project project2, @NotNull Collection<Change> changes) {
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project2);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        return ContainerUtil.mapNotNull(changes, (Function)changeToPsiFileMapper);
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project2, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        return ContainerUtil.emptyList();
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return -1;
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project2, @NotNull PsiFile file2) {
        return false;
    }
}

