/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class FileTreeIterator {
    private Queue<PsiFile> myCurrentFiles = new LinkedList<PsiFile>();
    private Queue<PsiDirectory> myCurrentDirectories = new LinkedList<PsiDirectory>();

    public FileTreeIterator(@NotNull List<PsiFile> files) {
        this.myCurrentFiles.addAll(files);
    }

    public FileTreeIterator(@NotNull Module module2) {
        this.myCurrentDirectories.addAll(FileTreeIterator.collectModuleDirectories(module2));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull Project project2) {
        this.myCurrentDirectories.addAll(FileTreeIterator.collectProjectDirectories(project2));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    @NotNull
    public static List<PsiDirectory> collectProjectDirectories(@NotNull Project project2) {
        Module[] modules;
        ArrayList directories = ContainerUtil.newArrayList();
        for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
            directories.addAll(FileTreeIterator.collectModuleDirectories(module2));
        }
        return directories;
    }

    public FileTreeIterator(@NotNull PsiDirectory directory) {
        this.myCurrentDirectories.add(directory);
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull FileTreeIterator fileTreeIterator) {
        this.myCurrentFiles = new LinkedList<PsiFile>(fileTreeIterator.myCurrentFiles);
        this.myCurrentDirectories = new LinkedList<PsiDirectory>(fileTreeIterator.myCurrentDirectories);
    }

    @NotNull
    public PsiFile next() {
        if (this.myCurrentFiles.isEmpty()) {
            throw new NoSuchElementException();
        }
        PsiFile current = this.myCurrentFiles.poll();
        this.expandDirectoriesUntilFilesNotEmpty();
        return current;
    }

    public boolean hasNext() {
        return !this.myCurrentFiles.isEmpty();
    }

    private void expandDirectoriesUntilFilesNotEmpty() {
        while (this.myCurrentFiles.isEmpty() && !this.myCurrentDirectories.isEmpty()) {
            PsiDirectory dir = this.myCurrentDirectories.poll();
            this.expandDirectory(dir);
        }
    }

    private void expandDirectory(@NotNull PsiDirectory dir) {
        Collections.addAll(this.myCurrentFiles, dir.getFiles());
        Collections.addAll(this.myCurrentDirectories, dir.getSubdirectories());
    }

    @NotNull
    public static List<PsiDirectory> collectModuleDirectories(Module module2) {
        VirtualFile[] contentRoots;
        ArrayList dirs = ContainerUtil.newArrayList();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)module2.getProject()).findDirectory(root);
            if (dir == null) continue;
            dirs.add(dir);
        }
        return dirs;
    }
}

