/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.java15api.Java15APIUsageInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceSuggester {
    public static final String[] FUNCTIONAL_INTERFACES = new String[]{"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.Comparator", "com.intellij.util.Function", "com.intellij.util.Consumer", "com.intellij.openapi.util.Computable", "com.intellij.openapi.util.Condition", "com.intellij.util.Processor", "com.intellij.util.Producer", "com.google.common.base.Function", "com.google.common.base.Predicate", "com.google.common.base.Supplier", "org.apache.commons.collections.Closure", "org.apache.commons.collections.Factory", "org.apache.commons.collections.Predicate", "org.apache.commons.collections.Transformer", "gnu.trove.TObjectFunction", "gnu.trove.TObjectProcedure", "gnu.trove.TObjectObjectProcedure"};

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(final @NotNull PsiFunctionalExpression expression) {
        final PsiType qualifierType = expression instanceof PsiMethodReferenceExpression ? PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression)) : null;
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(expression, new NullableFunction<PsiClass, PsiType>(){

            @Nullable
            public PsiType fun(PsiClass aClass) {
                return FunctionalInterfaceSuggester.composeAcceptableType(aClass, expression, qualifierType);
            }
        });
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(final @NotNull PsiMethod method) {
        if (method.isConstructor()) {
            return Collections.emptyList();
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, new NullableFunction<PsiClass, PsiType>(){

            @Nullable
            public PsiType fun(PsiClass aClass) {
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
                if (interfaceMethod != null) {
                    PsiClassType[] thrownTypes;
                    PsiParameter[] interfaceMethodParameters;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != (interfaceMethodParameters = interfaceMethod.getParameterList().getParameters()).length) {
                        return null;
                    }
                    PsiType[] left = new PsiType[parameters.length + 1];
                    PsiType[] right = new PsiType[parameters.length + 1];
                    for (int i = 0; i < parameters.length; ++i) {
                        left[i] = interfaceMethodParameters[i].getType();
                        right[i] = parameters[i].getType();
                    }
                    left[parameters.length] = method.getReturnType();
                    right[parameters.length] = interfaceMethod.getReturnType();
                    PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
                    PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)aClass.getProject()).inferTypeArguments(typeParameters, left, right, PsiUtil.getLanguageLevel((PsiElement)method));
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
                        return null;
                    }
                    for (int i = 0; i < interfaceMethodParameters.length; ++i) {
                        if (TypeConversionUtil.isAssignable((PsiType)parameters[i].getType(), (PsiType)substitutor.substitute(interfaceMethodParameters[i].getType()))) continue;
                        return null;
                    }
                    PsiType returnType = method.getReturnType();
                    PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
                    if (returnType != null && !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)substitutor.substitute(interfaceMethodReturnType))) {
                        return null;
                    }
                    if (PsiType.VOID.equals((Object)returnType) && !PsiType.VOID.equals((Object)interfaceMethodReturnType)) {
                        return null;
                    }
                    PsiClassType[] interfaceThrownTypes = interfaceMethod.getThrowsList().getReferencedTypes();
                    for (PsiClassType thrownType : thrownTypes = method.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isHandledBy(thrownType, interfaceThrownTypes, substitutor)) continue;
                        return null;
                    }
                    for (PsiClassType thrownType : interfaceThrownTypes) {
                        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{PsiCodeBlock.class});
                        if (codeBlock != null && ExceptionUtil.isHandled(thrownType, (PsiElement)codeBlock)) continue;
                        return null;
                    }
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    return elementFactory.createType(aClass, substitutor);
                }
                return null;
            }
        });
    }

    private static <T extends PsiElement> Collection<? extends PsiType> suggestFunctionalInterfaces(final @NotNull T element, final NullableFunction<PsiClass, PsiType> acceptanceChecker) {
        GlobalSearchScope allScope;
        Project project2 = element.getProject();
        final HashSet types = new HashSet();
        Processor<PsiMember> consumer = new Processor<PsiMember>(){

            public boolean process(PsiMember member) {
                if (member instanceof PsiClass && !Java15APIUsageInspectionBase.isForbiddenApiUsage(member, PsiUtil.getLanguageLevel((PsiElement)element))) {
                    if (!JavaResolveUtil.isAccessible(member, null, member.getModifierList(), element, null, null)) {
                        return true;
                    }
                    ContainerUtil.addIfNotNull((Collection)types, (Object)acceptanceChecker.fun((Object)((PsiClass)member)));
                }
                return true;
            }
        };
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass functionalInterfaceClass = psiFacade.findClass("java.lang.FunctionalInterface", allScope = GlobalSearchScope.allScope((Project)project2));
        if (functionalInterfaceClass != null) {
            AnnotatedMembersSearch.search((PsiClass)functionalInterfaceClass, (SearchScope)element.getResolveScope()).forEach((Processor)consumer);
        }
        for (String functionalInterface : FUNCTIONAL_INTERFACES) {
            PsiClass aClass = psiFacade.findClass(functionalInterface, allScope);
            if (aClass == null) continue;
            consumer.process((Object)aClass);
        }
        ArrayList typesToSuggest = new ArrayList(types);
        Collections.sort(typesToSuggest, new Comparator<PsiType>(){

            @Override
            public int compare(PsiType o1, PsiType o2) {
                return o1.getCanonicalText().compareTo(o2.getCanonicalText());
            }
        });
        return typesToSuggest;
    }

    private static PsiType composeAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression, PsiType qualifierType) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)interface2Consider.getProject());
        PsiClassType type = elementFactory.createType(interface2Consider, PsiSubstitutor.EMPTY);
        if (expression.isAcceptable((PsiType)type)) {
            return type;
        }
        return FunctionalInterfaceSuggester.composeAcceptableType(interface2Consider, expression, qualifierType, elementFactory);
    }

    private static PsiType composeAcceptableType(PsiClass interface2Consider, PsiFunctionalExpression expression, PsiType qualifierType, PsiElementFactory elementFactory) {
        PsiMethod interfaceMethod;
        if (interface2Consider.hasTypeParameters() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)interface2Consider)) != null) {
            PsiParameter[] functionalExprParameters;
            PsiType[] right;
            PsiType[] left;
            PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
            int offset = 0;
            if (expression instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression).hasFormalParameterTypes()) {
                left = new PsiType[parameters.length];
                right = new PsiType[parameters.length];
                functionalExprParameters = ((PsiLambdaExpression)expression).getParameterList().getParameters();
                if (parameters.length != functionalExprParameters.length) {
                    return null;
                }
            } else if (expression instanceof PsiMethodReferenceExpression) {
                left = new PsiType[parameters.length + 1];
                right = new PsiType[parameters.length + 1];
                PsiMethod method = FunctionalInterfaceSuggester.getTargetMethod((PsiMethodReferenceExpression)expression, qualifierType, parameters, left, right);
                if (method == null) {
                    return null;
                }
                functionalExprParameters = method.getParameterList().getParameters();
                if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression)) && !method.hasModifierProperty("static")) {
                    offset = 1;
                }
                left[parameters.length] = method.getReturnType();
                right[parameters.length] = interfaceMethod.getReturnType();
            } else {
                return null;
            }
            for (int i = 0; i < functionalExprParameters.length; ++i) {
                left[i + offset] = parameters[i + offset].getType();
                right[i + offset] = functionalExprParameters[i].getType();
            }
            PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)interface2Consider.getProject()).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression));
            PsiClassType type = elementFactory.createType(interface2Consider, substitutor);
            if (expression.isAcceptable((PsiType)type)) {
                return type;
            }
        }
        return null;
    }

    @Nullable
    private static PsiMethod getTargetMethod(PsiMethodReferenceExpression expression, PsiType qualifierType, PsiParameter[] parameters, PsiType[] left, PsiType[] right) {
        JavaResolveResult[] results;
        boolean staticallyReferenced = PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression);
        for (JavaResolveResult result : results = expression.multiResolve(true)) {
            PsiElement element = result.getElement();
            if (!(element instanceof PsiMethod)) continue;
            int offset = staticallyReferenced && !((PsiMethod)element).hasModifierProperty("static") ? 1 : 0;
            PsiParameter[] functionalExprParameters = ((PsiMethod)element).getParameterList().getParameters();
            if (functionalExprParameters.length + offset != parameters.length) continue;
            if (offset > 0) {
                if (qualifierType == null) continue;
                left[0] = parameters[0].getType();
                right[0] = qualifierType;
            }
            return (PsiMethod)element;
        }
        return null;
    }
}

