/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypesProvider {
    private static final ExpectedTypeInfo VOID_EXPECTED = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.VOID, 1, (PsiType)PsiType.VOID, TailType.SEMICOLON);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypesProvider");
    private static final int MAX_COUNT = 50;
    private static final ExpectedClassProvider ourGlobalScopeClassProvider = new ExpectedClassProvider(){

        @Override
        @NotNull
        public PsiField[] findDeclaredFields(@NotNull PsiManager manager, @NotNull String name) {
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            return cache.getFieldsByName(name, scope);
        }

        @Override
        @NotNull
        public PsiMethod[] findDeclaredMethods(@NotNull PsiManager manager, @NotNull String name) {
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            return cache.getMethodsByNameIfNotMoreThan(name, scope, 50);
        }
    };
    private static final PsiType[] PRIMITIVE_TYPES = new PsiType[]{PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE};

    private ExpectedTypesProvider() {
    }

    public static ExpectedTypesProvider getInstance(@NotNull Project project2) {
        return (ExpectedTypesProvider)ServiceManager.getService((Project)project2, ExpectedTypesProvider.class);
    }

    @NotNull
    public static ExpectedTypeInfo createInfo(@NotNull PsiType type, @ExpectedTypeInfo.Type int kind, PsiType defaultType, @NotNull TailType tailType) {
        return ExpectedTypesProvider.createInfoImpl(type, kind, defaultType, tailType);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, PsiType defaultType) {
        return ExpectedTypesProvider.createInfoImpl(type, 1, defaultType, TailType.NONE);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, @ExpectedTypeInfo.Type int kind, PsiType defaultType, @NotNull TailType tailType) {
        return new ExpectedTypeInfoImpl(type, kind, defaultType, tailType, null, ExpectedTypeInfoImpl.NULL);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, int kind, PsiType defaultType, @NotNull TailType tailType, PsiMethod calledMethod, NullableComputable<String> expectedName) {
        return new ExpectedTypeInfoImpl(type, kind, defaultType, tailType, calledMethod, expectedName);
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion) {
        return ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, false, false);
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, boolean voidable, boolean usedAfter) {
        return ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, ourGlobalScopeClassProvider, voidable, usedAfter);
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean usedAfter) {
        return ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, classProvider, false, usedAfter);
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
        if (expr == null) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        PsiElement parent = expr.getParent();
        if (expr instanceof PsiFunctionalExpression && parent instanceof PsiExpressionStatement) {
            Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces((PsiFunctionalExpression)expr);
            if (types.isEmpty()) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            ExpectedTypeInfo[] result = new ExpectedTypeInfo[types.size()];
            int i = 0;
            for (PsiType psiType : types) {
                result[i++] = new ExpectedTypeInfoImpl(psiType, 4, psiType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL);
            }
            return result;
        }
        MyParentVisitor visitor = new MyParentVisitor(expr, forCompletion, classProvider, voidable, usedAfter);
        if (parent != null) {
            parent.accept((PsiElementVisitor)visitor);
        }
        return visitor.getResult();
    }

    public static PsiType[] processExpectedTypes(@NotNull ExpectedTypeInfo[] infos, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project2) {
        LinkedHashSet<PsiType> set = new LinkedHashSet<PsiType>();
        for (ExpectedTypeInfo info : infos) {
            ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
            if (infoImpl.getDefaultType() instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)infoImpl.getDefaultType()).resolveGenerics();
                PsiClass aClass = (PsiClass)result.getElement();
                if (aClass instanceof PsiAnonymousClass) {
                    ExpectedTypesProvider.processType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType(), visitor, set);
                    ((PsiAnonymousClass)aClass).getBaseClassType().accept(visitor);
                } else {
                    ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
                }
            } else {
                ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
            }
            if (infoImpl.getKind() == 2) {
                ExpectedTypesProvider.processAllSuperTypes(infoImpl.getType(), visitor, project2, set);
                continue;
            }
            if (infoImpl.getKind() != 1 || !(infoImpl.getType() instanceof PsiPrimitiveType)) continue;
            ExpectedTypesProvider.processPrimitiveTypeAndSubtypes((PsiPrimitiveType)infoImpl.getType(), visitor, set);
        }
        return set.toArray(PsiType.createArray((int)set.size()));
    }

    private static void processType(@NotNull PsiType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<PsiType> typeSet) {
        PsiType accepted = (PsiType)type.accept(visitor);
        if (accepted != null) {
            typeSet.add(accepted);
        }
    }

    public static void processPrimitiveTypeAndSubtypes(@NotNull PsiPrimitiveType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<PsiType> set) {
        if (type.equals((Object)PsiType.BOOLEAN) || type.equals((Object)PsiType.VOID) || type.equals((Object)PsiType.NULL)) {
            return;
        }
        int i = 0;
        while (true) {
            PsiType primitive = PRIMITIVE_TYPES[i];
            ExpectedTypesProvider.processType(primitive, visitor, set);
            if (primitive.equals(type)) {
                return;
            }
            ++i;
        }
    }

    public static void processAllSuperTypes(@NotNull PsiType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project2, @NotNull Set<PsiType> set) {
        block6: {
            PsiType[] superTypes;
            block5: {
                if (!(type instanceof PsiPrimitiveType)) break block5;
                if (type.equals(PsiType.BOOLEAN) || type.equals(PsiType.VOID) || type.equals(PsiType.NULL)) {
                    return;
                }
                Stack stack = new Stack();
                int i = PRIMITIVE_TYPES.length - 1;
                while (!PRIMITIVE_TYPES[i].equals(type)) {
                    stack.push((Object)PRIMITIVE_TYPES[i]);
                    --i;
                }
                while (!stack.empty()) {
                    ExpectedTypesProvider.processType((PsiType)stack.pop(), visitor, set);
                }
                break block6;
            }
            PsiManager manager = PsiManager.getInstance((Project)project2);
            GlobalSearchScope resolveScope = type.getResolveScope();
            if (resolveScope == null) {
                resolveScope = GlobalSearchScope.allScope((Project)project2);
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypesProvider.processType((PsiType)objectType, visitor, set);
            if (!(type instanceof PsiClassType)) break block6;
            for (PsiType superType : superTypes = type.getSuperTypes()) {
                ExpectedTypesProvider.processType(superType, visitor, set);
                ExpectedTypesProvider.processAllSuperTypes(superType, visitor, project2, set);
            }
        }
    }

    @NotNull
    public static TailType getFinalCallParameterTailType(@NotNull PsiElement call, @Nullable PsiType returnType, @NotNull PsiMethod method) {
        boolean statementContext;
        if (method.isConstructor() && call instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)call).getMethodExpression() instanceof PsiSuperExpression) {
            return TailTypes.CALL_RPARENTH_SEMICOLON;
        }
        boolean chainable = !PsiType.VOID.equals((Object)returnType) && returnType != null || method.isConstructor() && call instanceof PsiNewExpression;
        PsiElement parent = call.getParent();
        boolean bl = statementContext = parent instanceof PsiExpressionStatement || parent instanceof PsiVariable || parent instanceof PsiCodeBlock;
        if (parent instanceof PsiThrowStatement || statementContext && !chainable) {
            return TailTypes.CALL_RPARENTH_SEMICOLON;
        }
        return TailTypes.CALL_RPARENTH;
    }

    public static interface ExpectedClassProvider {
        public PsiField[] findDeclaredFields(PsiManager var1, String var2);

        public PsiMethod[] findDeclaredMethods(PsiManager var1, String var2);
    }

    private static class MyParentVisitor
    extends JavaElementVisitor {
        private PsiExpression myExpr;
        private final boolean myForCompletion;
        private final boolean myUsedAfter;
        private final ExpectedClassProvider myClassProvider;
        private final boolean myVoidable;
        final List<ExpectedTypeInfo> myResult = ContainerUtil.newArrayList();
        @NonNls
        private static final String LENGTH_SYNTHETIC_ARRAY_FIELD = "length";

        private MyParentVisitor(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
            this.myExpr = expr;
            this.myForCompletion = forCompletion;
            this.myClassProvider = classProvider;
            this.myVoidable = voidable;
            this.myUsedAfter = usedAfter;
        }

        @NotNull
        public ExpectedTypeInfo[] getResult() {
            return this.myResult.toArray(new ExpectedTypeInfo[this.myResult.size()]);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent != null) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                parent.accept((PsiElementVisitor)visitor);
                for (final ExpectedTypeInfo info : visitor.myResult) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailTypes.RPARENTH, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                        @Nullable
                        public String compute() {
                            return ((ExpectedTypeInfoImpl)info).getExpectedName();
                        }
                    })));
                }
            }
        }

        public void visitAnnotationMethod(@NotNull PsiAnnotationMethod method) {
            PsiType type;
            if (this.myExpr == method.getDefaultValue() && (type = method.getReturnType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.SEMICOLON));
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (this.myForCompletion) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                expression.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                return;
            }
            String referenceName = expression.getReferenceName();
            if (referenceName != null) {
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    Collections.addAll(this.myResult, this.findClassesWithDeclaredMethod((PsiMethodCallExpression)parent, false));
                } else if (parent instanceof PsiReferenceExpression || parent instanceof PsiVariable || parent instanceof PsiExpression) {
                    if (LENGTH_SYNTHETIC_ARRAY_FIELD.equals(referenceName)) {
                        this.myResult.addAll(this.anyArrayType());
                    } else {
                        Collections.addAll(this.myResult, this.findClassesWithDeclaredField(expression));
                    }
                }
            }
        }

        public void visitExpressionStatement(PsiExpressionStatement statement2) {
            if (this.myVoidable) {
                this.myResult.add(VOID_EXPECTED);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            this.myExpr = (PsiExpression)this.myExpr.getParent();
            expression.getParent().accept((PsiElementVisitor)this);
        }

        public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
            PsiElement parent = initializer.getParent();
            while (parent instanceof PsiArrayInitializerMemberValue) {
                parent = parent.getParent();
            }
            PsiType type = parent instanceof PsiNameValuePair ? MyParentVisitor.getAnnotationMethodType((PsiNameValuePair)parent) : ((PsiAnnotationMethod)parent).getReturnType();
            if (type instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            PsiType type = MyParentVisitor.getAnnotationMethodType(pair);
            if (type == null) {
                return;
            }
            if (type instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, type));
            }
        }

        @Nullable
        private static PsiType getAnnotationMethodType(@NotNull PsiNameValuePair pair) {
            PsiElement method;
            PsiReference reference = pair.getReference();
            if (reference != null && (method = reference.resolve()) instanceof PsiMethod) {
                return ((PsiMethod)method).getReturnType();
            }
            return null;
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            PsiMethod scopeMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
            if (scopeMethod != null) {
                this.visitMethodReturnType(scopeMethod, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType), LambdaHighlightingUtil.insertSemicolonAfter(lambdaExpression));
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            boolean tailTypeSemicolon;
            PsiType type;
            PsiMethod method;
            NavigatablePsiElement psiElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)psiElement).getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                type = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                tailTypeSemicolon = LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)psiElement);
            } else if (psiElement instanceof PsiMethod) {
                method = (PsiMethod)psiElement;
                type = method.getReturnType();
                tailTypeSemicolon = true;
            } else {
                method = null;
                type = null;
                tailTypeSemicolon = true;
            }
            if (method != null) {
                this.visitMethodReturnType(method, type, tailTypeSemicolon);
            }
        }

        private void visitMethodReturnType(final PsiMethod scopeMethod, PsiType type, boolean tailTypeSemicolon) {
            if (type != null) {
                NullableComputable<String> expectedName = PropertyUtil.isSimplePropertyAccessor((PsiMethod)scopeMethod) ? new NullableComputable<String>(){

                    public String compute() {
                        return PropertyUtil.getPropertyName((PsiMethod)scopeMethod);
                    }
                } : ExpectedTypeInfoImpl.NULL;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, tailTypeSemicolon ? TailType.SEMICOLON : TailType.NONE, null, (NullableComputable<String>)((NullableComputable)expectedName)));
            }
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.IF_RPARENTH));
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (this.myExpr.equals(statement2.getCondition())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement2) {
            if (statement2.getAssertDescription() == this.myExpr) {
                PsiClassType stringType = PsiType.getJavaLangString((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope());
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)stringType, 0, (PsiType)stringType, TailType.SEMICOLON));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
            if (this.myExpr.equals(statement2.getIteratedValue())) {
                PsiType type = statement2.getIterationParameter().getType();
                PsiArrayType arrayType = type.createArrayType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, (PsiType)arrayType));
                PsiManager manager = statement2.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Iterable", statement2.getResolveScope());
                if (iterableClass != null && iterableClass.getTypeParameters().length == 1) {
                    HashMap map = new HashMap();
                    map.put(iterableClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)type));
                    PsiClassType iterableType = factory.createType(iterableClass, factory.createSubstitutor((Map)map));
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)iterableType, (PsiType)iterableType));
                }
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement2)) {
                return;
            }
            PsiManager manager = statement2.getManager();
            PsiClassType enumType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Enum", statement2.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)enumType, (PsiType)enumType));
        }

        public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement2) {
            PsiType type;
            PsiExpression expression;
            PsiSwitchStatement switchStatement = statement2.getEnclosingSwitchStatement();
            if (switchStatement != null && (expression = switchStatement.getExpression()) != null && (type = expression.getType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.CASE_COLON));
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)statement2.getProject()).getElementFactory();
            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)objectType));
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiType type = variable.getType();
            TailType tail = variable instanceof PsiResourceVariable ? TailType.NONE : TailType.SEMICOLON;
            this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, tail, null, (NullableComputable<String>)MyParentVisitor.getPropertyName(variable)));
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (this.myExpr.equals(assignment.getRExpression())) {
                PsiExpression lExpr = assignment.getLExpression();
                PsiType type = lExpr.getType();
                if (type != null) {
                    PsiElement refElement;
                    TailType tailType = MyParentVisitor.getAssignmentRValueTailType(assignment);
                    NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
                    if (lExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                        expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, tailType, null, (NullableComputable<String>)expectedName));
                }
            } else {
                PsiType type;
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    assignment.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiExpression rExpr = assignment.getRExpression();
                if (rExpr != null && (type = rExpr.getType()) != null && type != PsiType.NULL) {
                    PsiClass resolved;
                    if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) instanceof PsiAnonymousClass) {
                        type = ((PsiAnonymousClass)resolved).getBaseClassType();
                    }
                    int kind = assignment.getOperationTokenType() != JavaTokenType.EQ ? 0 : 2;
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, kind, type, TailType.NONE));
                }
            }
        }

        private static TailType getAssignmentRValueTailType(@NotNull PsiAssignmentExpression assignment) {
            if (assignment.getParent() instanceof PsiExpressionStatement) {
                if (!(assignment.getParent().getParent() instanceof PsiForStatement)) {
                    return TailType.SEMICOLON;
                }
                PsiForStatement forStatement = (PsiForStatement)assignment.getParent().getParent();
                if (!assignment.getParent().equals(forStatement.getUpdate())) {
                    return TailType.SEMICOLON;
                }
            }
            return TailType.NONE;
        }

        public void visitExpressionList(@NotNull PsiExpressionList list) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            if (list.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)list.getParent();
                CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false, true);
                Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, list, this.myExpr, this.myForCompletion));
            } else if (list.getParent() instanceof PsiEnumConstant) {
                this.getExpectedArgumentsTypesForEnumConstant((PsiEnumConstant)list.getParent(), list);
            } else if (list.getParent() instanceof PsiNewExpression) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent(), list);
            } else if (list.getParent() instanceof PsiAnonymousClass) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent().getParent(), list);
            }
        }

        private void getExpectedArgumentsTypesForEnumConstant(@NotNull PsiEnumConstant enumConstant, @NotNull PsiExpressionList list) {
            PsiClass aClass = enumConstant.getContainingClass();
            if (aClass != null) {
                LOG.assertTrue(aClass.isEnum());
                this.getExpectedTypesForConstructorCall(aClass, list, PsiSubstitutor.EMPTY);
            }
        }

        private void getExpectedArgumentsTypesForNewExpression(@NotNull PsiNewExpression newExpr, @NotNull PsiExpressionList list) {
            if (PsiDiamondType.hasDiamond((PsiNewExpression)newExpr)) {
                Object[] candidates = PsiDiamondTypeImpl.collectStaticFactories(newExpr, DuplicateConflictResolver.INSTANCE);
                if (candidates != null) {
                    PsiExpressionList argumentList = newExpr.getArgumentList();
                    Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall((CandidateInfo[])ContainerUtil.map((Object[])candidates, candidate -> (CandidateInfo)candidate, (Object[])CandidateInfo.EMPTY_ARRAY), argumentList, this.myExpr, this.myForCompletion));
                }
                return;
            }
            PsiType newType = newExpr.getType();
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)newType);
                PsiClass newClass = (PsiClass)resolveResult.getElement();
                if (newClass instanceof PsiAnonymousClass) {
                    PsiAnonymousClass anonymous = (PsiAnonymousClass)newClass;
                    if ((newClass = anonymous.getBaseClassType().resolve()) == null) {
                        return;
                    }
                    substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)newClass, (PsiClass)anonymous, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                } else if (newClass != null) {
                    substitutor = resolveResult.getSubstitutor();
                } else {
                    return;
                }
                this.getExpectedTypesForConstructorCall(newClass, list, substitutor);
            }
        }

        private void getExpectedTypesForConstructorCall(@NotNull PsiClass referencedClass, @NotNull PsiExpressionList argumentList, PsiSubstitutor substitutor) {
            ArrayList<MethodCandidateInfo> array = new ArrayList<MethodCandidateInfo>();
            for (PsiMethod constructor : referencedClass.getConstructors()) {
                array.add(new MethodCandidateInfo((PsiElement)constructor, substitutor, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null));
            }
            CandidateInfo[] candidates = array.toArray(new CandidateInfo[array.size()]);
            Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, argumentList, this.myExpr, this.myForCompletion));
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expr) {
            PsiExpression[] operands = expr.getOperands();
            int index = Arrays.asList(operands).indexOf(this.myExpr);
            if (index < 0) {
                return;
            }
            if (this.myForCompletion && index == 0) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                expr.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                if (!(expr.getParent() instanceof PsiExpressionList)) {
                    for (int i = 0; i < this.myResult.size(); ++i) {
                        final ExpectedTypeInfo info = this.myResult.get(i);
                        this.myResult.set(i, ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.NONE, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                            @Nullable
                            public String compute() {
                                return ((ExpectedTypeInfoImpl)info).getExpectedName();
                            }
                        })));
                    }
                }
                return;
            }
            PsiExpression anotherExpr = index > 0 ? operands[0] : (1 < operands.length ? operands[1] : null);
            PsiType anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            IElementType i = expr.getOperationTokenType();
            if (i == JavaTokenType.MINUS || i == JavaTokenType.ASTERISK || i == JavaTokenType.DIV || i == JavaTokenType.PERC || i == JavaTokenType.LT || i == JavaTokenType.GT || i == JavaTokenType.LE || i == JavaTokenType.GE) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (i == JavaTokenType.PLUS) {
                if (anotherType == null || anotherType.equalsToText("java.lang.String")) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope());
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)(anotherType != null ? anotherType : objectType)));
                } else if (PsiType.DOUBLE.isAssignableFrom(anotherType)) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
            } else if (i == JavaTokenType.LTLT || i == JavaTokenType.GTGT || i == JavaTokenType.GTGTGT) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 3, (PsiType)PsiType.SHORT, TailType.NONE));
                }
            } else if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if ((i == JavaTokenType.OR || i == JavaTokenType.XOR || i == JavaTokenType.AND) && anotherType != null) {
                ExpectedTypeInfoImpl info = PsiType.BOOLEAN.equals((Object)anotherType) ? ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, anotherType);
                this.myResult.add(info);
            }
        }

        @Nullable
        private static ExpectedTypeInfo getEqualsType(@Nullable PsiExpression anotherExpr) {
            ExpectedTypeInfoImpl info;
            PsiElement refElement;
            PsiType anotherType;
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (anotherType == null) {
                return null;
            }
            NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
            if (anotherExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)anotherExpr).resolve()) instanceof PsiVariable) {
                expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
            }
            if (anotherType instanceof PsiPrimitiveType) {
                if (PsiType.BOOLEAN.equals((Object)anotherType)) {
                    info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else if (PsiType.NULL.equals((Object)anotherType)) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)anotherExpr.getManager(), (GlobalSearchScope)anotherExpr.getResolveScope());
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else {
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                }
            } else {
                info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
            }
            return info;
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expr) {
            TailType tailType;
            IElementType i = expr.getOperationTokenType();
            PsiType type = expr.getType();
            TailType tailType2 = tailType = expr.getParent() instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr.getParent()).getRExpression() == expr ? MyParentVisitor.getAssignmentRValueTailType((PsiAssignmentExpression)expr.getParent()) : TailType.NONE;
            if (i == JavaTokenType.PLUSPLUS || i == JavaTokenType.MINUSMINUS || i == JavaTokenType.TILDE) {
                ExpectedTypeInfoImpl info = this.myUsedAfter && type != null ? ExpectedTypesProvider.createInfoImpl(type, 0, type, tailType) : (type != null ? ExpectedTypesProvider.createInfoImpl(type, type instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, tailType) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 1, (PsiType)PsiType.INT, tailType));
                this.myResult.add(info);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, (PsiType)PsiType.INT, tailType));
            } else if (i == JavaTokenType.EXCL) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, tailType));
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expr) {
            if (this.myForCompletion) {
                return;
            }
            PsiType type = expr.getType();
            ExpectedTypeInfoImpl info = this.myUsedAfter && type != null ? ExpectedTypesProvider.createInfoImpl(type, 0, type, TailType.NONE) : (type != null ? ExpectedTypesProvider.createInfoImpl(type, type instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            this.myResult.add(info);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expr) {
            PsiType type;
            PsiElement pParent = expr.getParent();
            PsiType arrayType = null;
            if (pParent instanceof PsiVariable) {
                arrayType = ((PsiVariable)pParent).getType();
            } else if (pParent instanceof PsiNewExpression) {
                arrayType = ((PsiNewExpression)pParent).getType();
            } else if (pParent instanceof PsiArrayInitializerExpression && (type = ((PsiArrayInitializerExpression)pParent).getType()) instanceof PsiArrayType) {
                arrayType = ((PsiArrayType)type).getComponentType();
            }
            if (arrayType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            for (PsiExpression dimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.myExpr.equals(dimension)) continue;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
                return;
            }
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expr) {
            if (this.myExpr.equals(expr.getIndexExpression())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
            } else if (this.myExpr.equals(expr.getArrayExpression())) {
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    expr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiElement parent = expr.getParent();
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                parent.accept((PsiElementVisitor)visitor);
                ExpectedTypeInfo[] componentTypeInfo = visitor.getResult();
                if (componentTypeInfo.length == 0) {
                    this.myResult.addAll(this.anyArrayType());
                } else {
                    for (int i = 0; i < componentTypeInfo.length; ++i) {
                        ExpectedTypeInfo compInfo = componentTypeInfo[i];
                        PsiArrayType expectedArrayType = compInfo.getType().createArrayType();
                        this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)expectedArrayType, (PsiType)expectedArrayType));
                    }
                }
            }
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expr) {
            if (this.myExpr.equals(expr.getCondition())) {
                if (this.myForCompletion) {
                    this.myExpr = expr;
                    this.myExpr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if (this.myExpr.equals(expr.getThenExpression())) {
                ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion);
                for (int i = 0; i < types.length; ++i) {
                    final ExpectedTypeInfo info = types[i];
                    types[i] = ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.COND_EXPR_COLON, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                        @Nullable
                        public String compute() {
                            return ((ExpectedTypeInfoImpl)info).getExpectedName();
                        }
                    }));
                }
                Collections.addAll(this.myResult, types);
            } else {
                if (!this.myExpr.equals(expr.getElseExpression())) {
                    LOG.error(Arrays.asList(expr.getChildren()) + "; " + this.myExpr);
                }
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion));
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement2) {
            if (statement2.getException() == this.myExpr) {
                PsiMethod method;
                PsiManager manager = statement2.getManager();
                PsiClassType throwableType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", this.myExpr.getResolveScope());
                PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClass.class});
                PsiType[] throwsTypes = PsiType.EMPTY_ARRAY;
                if (container instanceof PsiMethod) {
                    throwsTypes = ((PsiMethod)container).getThrowsList().getReferencedTypes();
                } else if (container instanceof PsiLambdaExpression && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)container)) != null) {
                    throwsTypes = method.getThrowsList().getReferencedTypes();
                }
                if (throwsTypes.length == 0) {
                    PsiClassType exceptionType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Exception", this.myExpr.getResolveScope());
                    throwsTypes = new PsiClassType[]{exceptionType};
                }
                for (int i = 0; i < throwsTypes.length; ++i) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)(this.myExpr instanceof PsiTypeCastExpression && this.myForCompletion ? throwsTypes[i] : throwableType), 1, throwsTypes[i], TailType.SEMICOLON));
                }
            }
        }

        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            PsiType type;
            if (codeFragment instanceof PsiExpressionCodeFragment && (type = ((PsiExpressionCodeFragment)codeFragment).getExpectedType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, type));
            }
        }

        @NotNull
        private ExpectedTypeInfo[] getExpectedArgumentTypesForMethodCall(@NotNull CandidateInfo[] allCandidates, @NotNull PsiExpressionList argumentList, @NotNull PsiExpression argument, boolean forCompletion) {
            PsiSubstitutor substitutor;
            PsiMethod method;
            PsiExpression[] leftArgs;
            if (allCandidates.length == 0) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myExpr.getProject()).getResolveHelper();
            ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo candidate : allCandidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !helper.isAccessible((PsiMember)element, (PsiElement)argumentList, null)) continue;
                methodCandidates.add(candidate);
            }
            Object[] args = (PsiExpression[])argumentList.getExpressions().clone();
            int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
            LOG.assertTrue(index >= 0);
            if (index <= args.length - 1) {
                leftArgs = new PsiExpression[index];
                System.arraycopy(args, 0, leftArgs, 0, index);
                if (forCompletion) {
                    args[index] = null;
                }
            } else {
                leftArgs = null;
            }
            CompletionParameterTypeInferencePolicy policy = forCompletion ? CompletionParameterTypeInferencePolicy.INSTANCE : DefaultParameterTypeInferencePolicy.INSTANCE;
            LinkedHashSet<ExpectedTypeInfo> array = new LinkedHashSet<ExpectedTypeInfo>();
            for (CandidateInfo candidateInfo : methodCandidates) {
                method = (PsiMethod)candidateInfo.getElement();
                if (candidateInfo instanceof MethodCandidateInfo) {
                    MethodCandidateInfo info = (MethodCandidateInfo)candidateInfo;
                    substitutor = (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, () -> MyParentVisitor.lambda$getExpectedArgumentTypesForMethodCall$1(info, (ParameterTypeInferencePolicy)policy, (PsiExpression[])args));
                    if (!info.isStaticsScopeCorrect() && method != null && !method.hasModifierProperty("static")) {
                        continue;
                    }
                } else {
                    substitutor = (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, () -> ((CandidateInfo)candidateInfo).getSubstitutor());
                }
                if (substitutor == null) {
                    return ExpectedTypeInfo.EMPTY_ARRAY;
                }
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, (PsiExpression[])args, index, method, substitutor, array);
                if (leftArgs == null || !(candidateInfo instanceof MethodCandidateInfo) || (substitutor = (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)argumentList, false, () -> MyParentVisitor.lambda$getExpectedArgumentTypesForMethodCall$2(candidateInfo, (ParameterTypeInferencePolicy)policy, leftArgs))) == null) continue;
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, leftArgs, index, method, substitutor, array);
            }
            if (forCompletion && array.isEmpty()) {
                for (CandidateInfo candidate : methodCandidates) {
                    method = (PsiMethod)candidate.getElement();
                    substitutor = candidate.getSubstitutor();
                    PsiParameter[] params = method.getParameterList().getParameters();
                    if (params.length <= index) continue;
                    PsiParameter param = params[index];
                    PsiType paramType = MyParentVisitor.getParameterType(param, substitutor);
                    TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, params);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(paramType, 1, paramType, tailType, method, (NullableComputable<String>)MyParentVisitor.getPropertyName((PsiVariable)param));
                    array.add(info);
                }
            }
            return array.toArray(new ExpectedTypeInfo[array.size()]);
        }

        @NotNull
        private static TailType getMethodArgumentTailType(@NotNull PsiExpression argument, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiParameter[] params) {
            if (index >= params.length || index == params.length - 2 && params[index + 1].isVarArgs()) {
                return TailType.NONE;
            }
            if (index == params.length - 1) {
                PsiElement call = argument.getParent().getParent();
                if (call instanceof SyntheticElement) {
                    return TailType.NONE;
                }
                PsiType returnType = method.getReturnType();
                if (returnType != null) {
                    returnType = substitutor.substitute(returnType);
                }
                return ExpectedTypesProvider.getFinalCallParameterTailType(call, returnType, method);
            }
            return TailType.COMMA;
        }

        private static void inferMethodCallArgumentTypes(@NotNull PsiExpression argument, boolean forCompletion, @NotNull PsiExpression[] args, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull Set<ExpectedTypeInfo> array) {
            LOG.assertTrue(substitutor.isValid());
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!forCompletion && parameters.length != args.length) {
                return;
            }
            if (parameters.length <= index && !method.isVarArgs()) {
                return;
            }
            for (int j = 0; j < index; ++j) {
                PsiType paramType = MyParentVisitor.getParameterType(parameters[Math.min(parameters.length - 1, j)], substitutor);
                PsiType argType = args[j].getType();
                if (argType == null || paramType.isAssignableFrom(argType)) continue;
                return;
            }
            PsiParameter parameter = parameters[Math.min(parameters.length - 1, index)];
            PsiType parameterType = MyParentVisitor.getParameterType(parameter, substitutor);
            TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, parameters);
            PsiType defaultType = MyParentVisitor.getDefaultType(method, substitutor, parameterType, argument, args, index);
            NullableComputable<String> propertyName = MyParentVisitor.getPropertyName((PsiVariable)parameter);
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parameterType, 1, defaultType, tailType, method, (NullableComputable<String>)propertyName);
            array.add(info);
            if (index == parameters.length - 1 && parameter.isVarArgs()) {
                PsiArrayType arrayType = parameterType.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, tailType, method, (NullableComputable<String>)propertyName);
                array.add(info1);
            }
        }

        @Nullable
        private static PsiType getTypeParameterValue(@NotNull PsiClass rootClass, @NotNull PsiClass derivedClass, PsiSubstitutor substitutor, int index) {
            PsiType type;
            PsiSubstitutor psiSubstitutor;
            PsiTypeParameter[] typeParameters = rootClass.getTypeParameters();
            if (typeParameters.length > index && (psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)rootClass, (PsiClass)derivedClass, (PsiSubstitutor)substitutor)) != null && (type = psiSubstitutor.substitute(typeParameters[index])) != null) {
                return type;
            }
            return null;
        }

        @Nullable
        protected static PsiType checkMethod(@NotNull PsiMethod method, final @NotNull @NonNls String className, final @NotNull NullableFunction<PsiClass, PsiType> function) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            if (className.equals(containingClass.getQualifiedName())) {
                return (PsiType)function.fun((Object)containingClass);
            }
            final PsiType[] type = new PsiType[]{null};
            DeepestSuperMethodsSearch.search((PsiMethod)method).forEach((Processor)new Processor<PsiMethod>(){

                public boolean process(@NotNull PsiMethod psiMethod) {
                    PsiClass rootClass = psiMethod.getContainingClass();
                    assert (rootClass != null);
                    if (className.equals(rootClass.getQualifiedName())) {
                        type[0] = (PsiType)function.fun((Object)rootClass);
                        return false;
                    }
                    return true;
                }
            });
            return type[0];
        }

        @Nullable
        private static PsiType getDefaultType(@NotNull PsiMethod method, final PsiSubstitutor substitutor, @NotNull PsiType parameterType, final @NotNull PsiExpression argument, @NotNull PsiExpression[] args, int index) {
            PsiType typeArg;
            String className;
            PsiType type;
            PsiType type2;
            final PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return parameterType;
            }
            final String name = method.getName();
            if (("contains".equals(name) || "remove".equals(name)) && (type2 = MyParentVisitor.checkMethod(method, "java.util.Collection", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(@NotNull PsiClass psiClass) {
                    return MyParentVisitor.getTypeParameterValue(psiClass, containingClass, substitutor, 0);
                }
            })) != null) {
                return type2;
            }
            if (("containsKey".equals(name) || "remove".equals(name) || "get".equals(name) || "containsValue".equals(name)) && (type2 = MyParentVisitor.checkMethod(method, "java.util.Map", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(@NotNull PsiClass psiClass) {
                    return MyParentVisitor.getTypeParameterValue(psiClass, containingClass, substitutor, name.equals("containsValue") ? 1 : 0);
                }
            })) != null) {
                return type2;
            }
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
            if ("equals".equals(name) && (type = MyParentVisitor.checkMethod(method, "java.lang.Object", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(PsiClass psiClass) {
                    PsiElement parent = argument.getParent().getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression expression = (PsiMethodCallExpression)parent;
                        PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
                        if (qualifierExpression != null) {
                            return qualifierExpression.getType();
                        }
                        PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)parent, PsiClass.class, (boolean)true);
                        if (aClass != null) {
                            return factory.createType(aClass);
                        }
                    }
                    return null;
                }
            })) != null) {
                return type;
            }
            int argCount = Math.max(index + 1, args.length);
            if (("assertEquals".equals(name) || "assertSame".equals(name) && method.getParameterList().getParametersCount() == argCount) && (argCount == 2 || argCount == 3 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.String"))) {
                ExpectedTypeInfo info;
                int other;
                int n = other = index == argCount - 1 ? index - 1 : index + 1;
                if (args.length > other && (info = MyParentVisitor.getEqualsType(args[other])) != null && parameterType.isAssignableFrom(info.getDefaultType())) {
                    return info.getDefaultType();
                }
            }
            if ((className = containingClass.getName()) != null && className.startsWith("Log") && parameterType instanceof PsiClassType && ((typeArg = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.lang.Class", (int)0, (boolean)true)) instanceof PsiWildcardType && !((PsiWildcardType)typeArg).isBounded() || typeArg != null && TypeConversionUtil.erasure((PsiType)typeArg).equalsToText("java.lang.Object"))) {
                PsiClass placeClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)argument, (Class[])new Class[]{PsiClass.class});
                PsiClass classClass = ((PsiClassType)parameterType).resolve();
                if (placeClass != null && classClass != null) {
                    return factory.createType(classClass, (PsiType)factory.createType(placeClass));
                }
            }
            return parameterType;
        }

        private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor) {
            PsiType parameterType;
            PsiType type = parameter.getType();
            LOG.assertTrue(type.isValid());
            if (parameter.isVarArgs()) {
                if (type instanceof PsiArrayType) {
                    type = ((PsiArrayType)type).getComponentType();
                } else {
                    LOG.error("Vararg parameter with non-array type. Class=" + parameter.getClass() + "; type=" + parameter.getType());
                }
            }
            if ((parameterType = substitutor.substitute(type)) instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)parameterType).getBound();
                return bound != null ? bound : PsiType.getJavaLangObject((PsiManager)parameter.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)parameter.getProject()));
            }
            return parameterType;
        }

        @Nullable
        private static NullableComputable<String> getPropertyName(final @NotNull PsiVariable variable) {
            return new NullableComputable<String>(){

                public String compute() {
                    String name = variable.getName();
                    if (name == null) {
                        return null;
                    }
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
                    VariableKind variableKind = codeStyleManager.getVariableKind(variable);
                    return codeStyleManager.variableNameToPropertyName(name, variableKind);
                }
            };
        }

        @NotNull
        private List<ExpectedTypeInfo> anyArrayType() {
            PsiArrayType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope()).createArrayType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, (PsiType)objType);
            ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE.createArrayType(), (PsiType)PsiType.INT.createArrayType());
            PsiArrayType booleanType = PsiType.BOOLEAN.createArrayType();
            ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)booleanType, 0, (PsiType)booleanType, TailType.NONE);
            return Arrays.asList(info, info1, info2);
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredMethod(@NotNull PsiMethodCallExpression methodCallExpr, boolean forCompletion) {
            PsiReferenceExpression reference = methodCallExpr.getMethodExpression();
            if (reference.getQualifierExpression() instanceof PsiClassObjectAccessExpression) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiManager manager = methodCallExpr.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiMethod[] methods = this.myClassProvider.findDeclaredMethods(reference.getManager(), reference.getReferenceName());
            THashSet types = new THashSet();
            for (PsiMethod method : methods) {
                PsiClassType type;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)reference, aClass)) continue;
                PsiSubstitutor substitutor = ExpectedTypeUtil.inferSubstitutor(method, methodCallExpr, forCompletion);
                PsiClassType psiClassType = type = substitutor == null ? facade.getElementFactory().createType(aClass) : facade.getElementFactory().createType(aClass, substitutor);
                if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                    types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 0, (PsiType)type, TailType.DOT));
                    continue;
                }
                if (method.findSuperMethods().length != 0) continue;
                types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 1, (PsiType)type, TailType.DOT));
            }
            return types.toArray(new ExpectedTypeInfo[types.size()]);
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredField(@NotNull PsiReferenceExpression expression) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiField[] fields = this.myClassProvider.findDeclaredFields(expression.getManager(), expression.getReferenceName());
            ArrayList<ExpectedTypeInfoImpl> types = new ArrayList<ExpectedTypeInfoImpl>();
            for (PsiField field : fields) {
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)field, (PsiElement)expression, aClass)) continue;
                PsiClassType type = facade.getElementFactory().createType(aClass);
                int kind = field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("private") ? 0 : 1;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)type, kind, (PsiType)type, TailType.DOT);
                types.add(info);
            }
            return types.toArray(new ExpectedTypeInfo[types.size()]);
        }

        private static /* synthetic */ PsiSubstitutor lambda$getExpectedArgumentTypesForMethodCall$2(CandidateInfo candidateInfo, ParameterTypeInferencePolicy parameterTypeInferencePolicy, PsiExpression[] psiExpressionArray) {
            return ((MethodCandidateInfo)candidateInfo).inferTypeArguments(parameterTypeInferencePolicy, psiExpressionArray, true);
        }

        private static /* synthetic */ PsiSubstitutor lambda$getExpectedArgumentTypesForMethodCall$1(MethodCandidateInfo methodCandidateInfo, ParameterTypeInferencePolicy parameterTypeInferencePolicy, PsiExpression[] psiExpressionArray) {
            return methodCandidateInfo.inferTypeArguments(parameterTypeInferencePolicy, psiExpressionArray, true);
        }
    }
}

