/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtilBase
extends CodeInsightUtilCore {
    private CodeInsightUtilBase() {
    }

    public boolean prepareFileForWrite(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        final VirtualFile file2 = psiFile.getVirtualFile();
        final Project project2 = psiFile.getProject();
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{file2})) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, file2), true);
                if (editor != null && editor.getComponent().isDisplayable()) {
                    HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"error.hint.file.is.readonly", (Object[])new Object[]{file2.getPresentableUrl()}));
                }
            }
        }, project2.getDisposed());
        return false;
    }

    public boolean preparePsiElementForWrite(@Nullable PsiElement element) {
        PsiFile file2 = element == null ? null : element.getContainingFile();
        return this.prepareFileForWrite(file2);
    }

    public boolean preparePsiElementsForWrite(PsiElement ... elements) {
        return this.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public boolean preparePsiElementsForWrite(@NotNull Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return true;
        }
        THashSet files = new THashSet();
        Project project2 = null;
        for (PsiElement psiElement : elements) {
            PsiFile file2;
            if (psiElement == null || (file2 = psiElement.getContainingFile()) == null || !file2.isPhysical()) continue;
            project2 = file2.getProject();
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) continue;
            files.add(virtualFile);
        }
        if (!files.isEmpty()) {
            VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)files);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(virtualFiles);
            return !operationStatus.hasReadonlyFiles();
        }
        return true;
    }

    public boolean prepareVirtualFilesForWrite(@NotNull Project project2, @NotNull Collection<VirtualFile> files) {
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(files);
        return !status.hasReadonlyFiles();
    }

    public static boolean prepareEditorForWrite(@NotNull Editor editor) {
        if (!editor.isViewer()) {
            return true;
        }
        CodeInsightUtilBase.showReadOnlyViewWarning(editor);
        return false;
    }

    public static void showReadOnlyViewWarning(Editor editor) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        JComponent component = HintUtil.createInformationLabel("This view is read-only");
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }
}

