/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.text.CharSequenceReader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotations = ContainerUtil.createConcurrentSoftValueMap();
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache = new WeakKeyWeakValueHashMap();
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStamp = ContainerUtil.createConcurrentSoftMap();
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache = new ConcurrentMostlySingularMultiMap();
    private final CharTableImpl charTable = new CharTableImpl();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                BaseExternalAnnotationsManager.this.dropCache();
            }
        }, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        return PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)showParamName, (int)Integer.MAX_VALUE);
    }

    @NotNull
    static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        PsiElement original = element.getOriginalElement();
        return original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> list = this.collectExternalAnnotations(listOwner);
        AnnotationData data = BaseExternalAnnotationsManager.findByFQN(list, annotationFQN);
        return data == null ? null : data.getAnnotation(this);
    }

    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map, final @NotNull String annotationFQN) {
        return (AnnotationData)ContainerUtil.find(map, (Condition)new Condition<AnnotationData>(){

            public boolean value(AnnotationData data) {
                return data.myFqName.equals(annotationFQN);
            }
        });
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return result.isEmpty() ? null : (PsiAnnotation[])ContainerUtil.map2Array(result, (Object[])PsiAnnotation.EMPTY_ARRAY, (Function)new Function<AnnotationData, PsiAnnotation>(){

            public PsiAnnotation fun(AnnotationData data) {
                return data.getAnnotation(BaseExternalAnnotationsManager.this);
            }
        });
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (!this.hasAnyAnnotationsRoots()) {
            return Collections.emptyList();
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get((Object)listOwner)) != NO_DATA && cached.isEmpty()) continue;
            return cached;
        } while (!this.cache.replace((Object)listOwner, (Collection)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        Map<AnnotationData, AnnotationData> map = this.myAnnotationDataCache;
        synchronized (map) {
            AnnotationData interned = this.myAnnotationDataCache.get(data);
            if (interned == null) {
                this.myAnnotationDataCache.put(data, data);
                interned = data;
            }
            return interned;
        }
    }

    @NotNull
    private MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file2) {
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStamp.get(file2);
        long fileModificationStamp = file2.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            return (MostlySingularMultiMap)cached.getFirst();
        }
        DataParsingSaxHandler handler2 = new DataParsingSaxHandler(file2);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource((Reader)new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file2.getViewProvider().getContents()))), (DefaultHandler)handler2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Throwable)e);
        }
        MostlySingularMultiMap<String, AnnotationData> result = handler2.getResult();
        this.myAnnotationFileToDataAndModStamp.put(file2, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)Pair.pair(result, (Object)fileModificationStamp));
        return result;
    }

    protected void duplicateError(@NotNull PsiFile file2, @NotNull String externalName, @NotNull String text) {
        LOG.error(text + "; for signature: '" + externalName + "' in the " + file2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        CharTableImpl charTableImpl = this.charTable;
        synchronized (charTableImpl) {
            return this.charTable.doIntern(annotationFQN).toString();
        }
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            return NO_DATA;
        }
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            return NO_DATA;
        }
        SmartList result = new SmartList();
        for (PsiFile file2 : files) {
            if (!file2.isValid() || onlyWritable && !file2.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file2);
            ContainerUtil.addAll((Collection)result, (Iterable)fileData.get((Object)externalName));
        }
        if (result.isEmpty()) {
            return NO_DATA;
        }
        result.trimToSize();
        return result;
    }

    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        PsiFile containingFile = BaseExternalAnnotationsManager.preferCompiledElement(listOwner).getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotations.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (Object file2 : files) {
                if (file2.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        THashSet possibleAnnotations = new THashSet();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotations.add(psiFile);
        }
        if (possibleAnnotations.isEmpty()) {
            this.myExternalAnnotations.put(virtualFile, NULL_LIST);
            return null;
        }
        SmartList result = new SmartList((Collection)possibleAnnotations);
        Collections.sort(result, new Comparator<PsiFile>(){

            @Override
            public int compare(PsiFile f1, PsiFile f2) {
                boolean w2;
                boolean w1 = f1.isWritable();
                return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
            }
        });
        this.myExternalAnnotations.put(virtualFile, (List<PsiFile>)result);
        return result;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotations.clear();
        this.myAnnotationFileToDataAndModStamp.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value) {
        throw new UnsupportedOperationException();
    }

    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        throw new UnsupportedOperationException();
    }

    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value) {
        throw new UnsupportedOperationException();
    }

    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        throw new UnsupportedOperationException();
    }

    protected void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        VirtualFile virtualFile = fromFile.getVirtualFile();
        if (virtualFile != null) {
            this.myExternalAnnotations.put(virtualFile, annotationFiles);
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        annotation.putUserData(EXTERNAL_ANNO_MARKER, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).markReadOnly();
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        CharTableImpl charTableImpl = this.charTable;
        synchronized (charTableImpl) {
            DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
            PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
            if (!(element instanceof PsiAnnotation)) {
                throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
            }
            return BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        }
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName = null;
        private String myAnnotationFqn = null;
        private StringBuilder myArguments = null;

        private DataParsingSaxHandler(PsiFile file2) {
            this.myFile = file2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get((Object)this.myExternalName)) {
                    if (!existingData.myFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add((Object)this.myExternalName, (Object)BaseExternalAnnotationsManager.this.internAnnotationData(data));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    private static class AnnotationData {
        private final String myFqName;
        private final String myParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters) {
            this.myFqName = fqn;
            this.myParameters = parameters;
        }

        @NotNull
        private PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            PsiAnnotation a = this.myAnnotation;
            if (a == null) {
                String text = "@" + this.myFqName + (this.myParameters.isEmpty() ? "" : "(" + this.myParameters + ")");
                this.myAnnotation = a = BaseExternalAnnotationsManager.markAsExternalAnnotation(context.createAnnotationFromText(text));
            }
            return a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.myFqName.equals(data.myFqName) && this.myParameters.equals(data.myParameters);
        }

        public int hashCode() {
            int result = this.myFqName.hashCode();
            result = 31 * result + this.myParameters.hashCode();
            return result;
        }

        public String toString() {
            return this.myFqName + "(" + this.myParameters + ")";
        }
    }
}

