/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    @Nullable
    protected final Document myDocument;
    @NotNull
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialDocStamp;
    private final long myInitialPsiStamp;
    private volatile int[] myCompletionPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
    private volatile int[] myStartingPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
    private volatile int myId;
    private volatile boolean myDumb;
    private EditorColorsScheme myColorsScheme;

    protected TextEditorHighlightingPass(@NotNull Project project2, @Nullable Document document, boolean runIntentionPassAfter) {
        this.myDocument = document;
        this.myProject = project2;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialDocStamp = document == null ? 0L : document.getModificationStamp();
        this.myInitialPsiStamp = PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount();
    }

    protected TextEditorHighlightingPass(@NotNull Project project2, @Nullable Document document) {
        this(project2, document, true);
    }

    public final void collectInformation(@NotNull ProgressIndicator progress) {
        if (!this.isValid()) {
            return;
        }
        if (!(progress instanceof DaemonProgressIndicator)) {
            throw new IncorrectOperationException("Highlighting must be run under DaemonProgressIndicator, but got: " + progress);
        }
        this.myDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.doCollectInformation(progress);
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    public void setColorsScheme(@Nullable EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    protected boolean isValid() {
        if (this.isDumbMode() && !DumbService.isDumbAware((Object)this)) {
            return false;
        }
        if (PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount() != this.myInitialPsiStamp) {
            return false;
        }
        if (this.myDocument != null) {
            if (this.myDocument.getModificationStamp() != this.myInitialDocStamp) {
                return false;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            if (file2 == null || !file2.isValid()) {
                return false;
            }
        }
        return true;
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !(this instanceof DumbAware)) {
            PsiFile file2;
            Document document = this.getDocument();
            PsiFile psiFile = file2 = document == null ? null : PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (file2 != null) {
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.getDocument(), this.getId());
            }
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(@NotNull ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id) {
        this.myId = id;
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        return Collections.emptyList();
    }

    @NotNull
    public final int[] getCompletionPredecessorIds() {
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(@NotNull int[] completionPredecessorIds) {
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    @Nullable
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public final int[] getStartingPredecessorIds() {
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(@NotNull int[] startingPredecessorIds) {
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return (this.getClass().isAnonymousClass() ? this.getClass().getSuperclass() : this.getClass()).getSimpleName() + "; id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }
}

