/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSeparatorProvider {
    @Nullable
    public static List<LineMarkerInfo> getFileSeparators(PsiFile file2, final Document document) {
        ArrayList<LineMarkerInfo> result = new ArrayList<LineMarkerInfo>();
        for (LineMarkerInfo lineMarkerInfo : LineMarkersPass.queryLineMarkers(file2, document)) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result.add(lineMarkerInfo);
        }
        Collections.sort(result, new Comparator<LineMarkerInfo>(){

            @Override
            public int compare(LineMarkerInfo i1, LineMarkerInfo i2) {
                return FileSeparatorProvider.getDisplayLine(i1, document) - FileSeparatorProvider.getDisplayLine(i2, document);
            }
        });
        return result;
    }

    public static int getDisplayLine(@NotNull LineMarkerInfo lineMarkerInfo, @NotNull Document document) {
        int offset = lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? lineMarkerInfo.startOffset : lineMarkerInfo.endOffset;
        return document.getLineNumber(Math.min(document.getTextLength(), Math.max(0, offset))) + (lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? 0 : 1);
    }
}

