/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.ExportToHTMLDialog;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

class ExportToHTMLManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeEditor.printing.ExportToHTMLManager");
    private static FileNotFoundException myLastException;

    private ExportToHTMLManager() {
    }

    public static void executeExport(DataContext dataContext) throws FileNotFoundException {
        PsiDirectory psiDirectory = null;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            psiDirectory = (PsiDirectory)psiElement;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        String shortFileName = null;
        String directoryName = null;
        if (psiFile != null || psiDirectory != null) {
            if (psiFile != null) {
                shortFileName = psiFile.getVirtualFile().getName();
                if (psiDirectory == null) {
                    psiDirectory = psiFile.getContainingDirectory();
                }
            }
            if (psiDirectory != null) {
                directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
            }
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        boolean isSelectedTextEnabled = false;
        if (editor != null && editor.getSelectionModel().hasSelection()) {
            isSelectedTextEnabled = true;
        }
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(shortFileName, directoryName, isSelectedTextEnabled, project2);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project2);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            VirtualFile baseDir = project2.getBaseDir();
            exportToHTMLSettings.OUTPUT_DIRECTORY = baseDir != null ? baseDir.getPresentableUrl() + File.separator + "exportToHTML" : "";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        try {
            exportToHTMLDialog.apply();
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        if (exportToHTMLSettings.getPrintScope() != 4) {
            if (psiFile == null || psiFile.getText() == null) {
                return;
            }
            String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            HTMLTextPainter textPainter = new HTMLTextPainter(psiFile, project2, dirName, exportToHTMLSettings.PRINT_LINE_NUMBERS);
            if (exportToHTMLSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                int firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine);
            }
            textPainter.paint(null, psiFile.getFileType());
            if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                BrowserUtil.browse((String)textPainter.getHTMLFileName());
            }
        } else {
            myLastException = null;
            ExportRunnable exportRunnable = new ExportRunnable(exportToHTMLSettings, psiDirectory, outputDirectoryName, project2);
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)exportRunnable, CodeEditorBundle.message("export.to.html.title", new Object[0]), true, project2);
            if (myLastException != null) {
                throw myLastException;
            }
        }
    }

    private static boolean exportPsiFile(final PsiFile psiFile, final String outputDirectoryName, final Project project2, final HashMap<PsiFile, PsiFile> filesMap) {
        final ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project2);
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!psiFile.isValid()) {
                    return;
                }
                TreeMap<Integer, PsiReference> refMap = null;
                for (PrintOption printOption : (PrintOption[])Extensions.getExtensions(PrintOption.EP_NAME)) {
                    TreeMap<Integer, PsiReference> map = printOption.collectReferences(psiFile, (Map<PsiFile, PsiFile>)filesMap);
                    if (map == null) continue;
                    refMap = new TreeMap<Integer, PsiReference>();
                    refMap.putAll(map);
                }
                String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
                HTMLTextPainter textPainter = new HTMLTextPainter(psiFile, project2, dirName, exportToHTMLSettings.PRINT_LINE_NUMBERS);
                try {
                    textPainter.paint(refMap, psiFile.getFileType());
                }
                catch (FileNotFoundException e) {
                    myLastException = e;
                }
            }
        });
        return myLastException == null;
    }

    private static String constructOutputDirectory(PsiFile psiFile, String outputDirectoryName) {
        return ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outputDirectoryName);
    }

    private static String constructOutputDirectory(@NotNull PsiDirectory directory, String outputDirectoryName) {
        String qualifiedName = PsiDirectoryFactory.getInstance(directory.getProject()).getQualifiedName(directory, false);
        String dirName = outputDirectoryName;
        if (qualifiedName.length() > 0) {
            dirName = dirName + File.separator + qualifiedName.replace('.', File.separatorChar);
        }
        File dir = new File(dirName);
        dir.mkdirs();
        return dirName;
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, ArrayList<PsiFile> filesList, boolean isRecursive, String outputDirectoryName) throws FileNotFoundException {
        if (!psiDirectory.isValid()) {
            return;
        }
        PsiFile[] files = psiDirectory.getFiles();
        Collections.addAll(filesList, files);
        ExportToHTMLManager.generateIndexHtml(psiDirectory, isRecursive, outputDirectoryName);
        if (isRecursive) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = psiDirectory.getSubdirectories()) {
                ExportToHTMLManager.addToPsiFileList(directory, filesList, isRecursive, outputDirectoryName);
            }
        }
    }

    private static void generateIndexHtml(PsiDirectory psiDirectory, boolean recursive, String outputDirectoryName) throws FileNotFoundException {
        String indexHtmlName = ExportToHTMLManager.constructOutputDirectory(psiDirectory, outputDirectoryName) + File.separator + "index.html";
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexHtmlName), CharsetToolkit.UTF8_CHARSET);
        String title = PsiDirectoryFactory.getInstance(psiDirectory.getProject()).getQualifiedName(psiDirectory, true);
        try {
            writer.write("<html><head><title>" + title + "</title></head><body>");
            if (recursive) {
                PsiDirectory[] directories;
                for (PsiDirectory psiDirectory2 : directories = psiDirectory.getSubdirectories()) {
                    writer.write("<a href=\"" + psiDirectory2.getName() + "/index.html\"><b>" + psiDirectory2.getName() + "</b></a><br />");
                }
            }
            PsiFile[] files = psiDirectory.getFiles();
            for (PsiDirectory psiDirectory3 : files) {
                if (psiDirectory3 instanceof PsiBinaryFile) continue;
                writer.write("<a href=\"" + ExportToHTMLManager.getHTMLFileName((PsiFile)psiDirectory3) + "\">" + psiDirectory3.getVirtualFile().getName() + "</a><br />");
            }
            writer.write("</body></html>");
            writer.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    static String getHTMLFileName(PsiFile psiFile) {
        return psiFile.getVirtualFile().getName() + ".html";
    }

    private static class ExportRunnable
    implements Runnable {
        private final ExportToHTMLSettings myExportToHTMLSettings;
        private final PsiDirectory myPsiDirectory;
        private final String myOutputDirectoryName;
        private final Project myProject;

        public ExportRunnable(ExportToHTMLSettings exportToHTMLSettings, PsiDirectory psiDirectory, String outputDirectoryName, Project project2) {
            this.myExportToHTMLSettings = exportToHTMLSettings;
            this.myPsiDirectory = psiDirectory;
            this.myOutputDirectoryName = outputDirectoryName;
            this.myProject = project2;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            final ArrayList filesList = new ArrayList();
            final boolean isRecursive = this.myExportToHTMLSettings.isIncludeSubdirectories();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExportToHTMLManager.addToPsiFileList(myPsiDirectory, filesList, isRecursive, myOutputDirectoryName);
                    }
                    catch (FileNotFoundException e) {
                        myLastException = e;
                    }
                }
            });
            if (myLastException != null) {
                return;
            }
            HashMap filesMap = new HashMap();
            for (PsiFile psiFile : filesList) {
                filesMap.put((Object)psiFile, (Object)psiFile);
            }
            for (int i = 0; i < filesList.size(); ++i) {
                PsiFile psiFile;
                psiFile = (PsiFile)filesList.get(i);
                if (progressIndicator.isCanceled()) {
                    return;
                }
                progressIndicator.setText(CodeEditorBundle.message("export.to.html.generating.file.progress", ExportToHTMLManager.getHTMLFileName(psiFile)));
                progressIndicator.setFraction((double)i / (double)filesList.size());
                if (ExportToHTMLManager.exportPsiFile(psiFile, this.myOutputDirectoryName, this.myProject, (HashMap<PsiFile, PsiFile>)filesMap)) continue;
                return;
            }
            if (this.myExportToHTMLSettings.OPEN_IN_BROWSER) {
                String dirToShow = this.myExportToHTMLSettings.OUTPUT_DIRECTORY;
                if (!dirToShow.endsWith(File.separator)) {
                    dirToShow = dirToShow + File.separatorChar;
                }
                dirToShow = dirToShow + PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiDirectory, false).replace('.', File.separatorChar);
                BrowserUtil.browse((String)dirToShow);
            }
        }
    }
}

