/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EmmetOptions", storages={@Storage(value="emmet.xml")})
public class EmmetOptions
implements PersistentStateComponent<EmmetOptions> {
    private boolean myEmmetEnabled = true;
    private int myEmmetExpandShortcut = 9;
    private boolean myPreviewEnabled = false;
    private Set<String> myFiltersEnabledByDefault = ContainerUtil.newHashSet();
    private boolean myHrefAutoDetectEnabled = true;
    private boolean myAddEditPointAtTheEndOfTemplate = false;

    @NotNull
    public Set<String> getFiltersEnabledByDefault() {
        return this.myFiltersEnabledByDefault;
    }

    public void setFiltersEnabledByDefault(@NotNull Set<String> filtersEnabledByDefault) {
        this.myFiltersEnabledByDefault = filtersEnabledByDefault;
    }

    public boolean isFilterEnabledByDefault(@NotNull ZenCodingFilter filter) {
        return this.myFiltersEnabledByDefault.contains(filter.getSuffix());
    }

    public void setEmmetExpandShortcut(int emmetExpandShortcut) {
        this.myEmmetExpandShortcut = emmetExpandShortcut;
    }

    public int getEmmetExpandShortcut() {
        return this.myEmmetExpandShortcut;
    }

    public boolean isPreviewEnabled() {
        return this.myPreviewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.myPreviewEnabled = previewEnabled;
    }

    public boolean isEmmetEnabled() {
        return this.myEmmetEnabled;
    }

    public void setEmmetEnabled(boolean emmetEnabled) {
        this.myEmmetEnabled = emmetEnabled;
    }

    public void setHrefAutoDetectEnabled(boolean hrefAutoDetectEnabled) {
        this.myHrefAutoDetectEnabled = hrefAutoDetectEnabled;
    }

    public boolean isHrefAutoDetectEnabled() {
        return this.myHrefAutoDetectEnabled;
    }

    public boolean isAddEditPointAtTheEndOfTemplate() {
        return this.myAddEditPointAtTheEndOfTemplate;
    }

    public void setAddEditPointAtTheEndOfTemplate(boolean addEditPointAtTheEndOfTemplate) {
        this.myAddEditPointAtTheEndOfTemplate = addEditPointAtTheEndOfTemplate;
    }

    @Nullable
    public EmmetOptions getState() {
        return this;
    }

    public void loadState(EmmetOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static EmmetOptions getInstance() {
        return (EmmetOptions)ServiceManager.getService(EmmetOptions.class);
    }
}

