/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludeTable
extends ListTableWithButtons<Item> {
    private static final Pattern ourPackagePattern = Pattern.compile("(\\w+\\.)*\\w+");
    private static final ColumnInfo<Item, String> NAME_COLUMN = new ColumnInfo<Item, String>("Class or package"){

        @Nullable
        public String valueOf(Item pair) {
            return pair.exclude;
        }

        @Nullable
        public TableCellEditor getEditor(Item pair) {
            final JTextField field = GuiUtils.createUndoableTextField();
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    field.setForeground(ourPackagePattern.matcher(field.getText()).matches() ? UIUtil.getTableForeground() : JBColor.RED);
                }
            });
            return new DefaultCellEditor(field);
        }

        @Nullable
        public TableCellRenderer getRenderer(Item pair) {
            return new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!ourPackagePattern.matcher((String)value).matches()) {
                        component.setForeground((Color)JBColor.RED);
                    }
                    return component;
                }
            };
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item item, String value) {
            item.exclude = value;
        }
    };
    private static final ColumnInfo<Item, ExclusionScope> SCOPE_COLUMN = new ColumnInfo<Item, ExclusionScope>("Scope"){

        @Nullable
        public ExclusionScope valueOf(Item pair) {
            return pair.scope;
        }

        @Nullable
        public TableCellRenderer getRenderer(Item pair) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        @Nullable
        public TableCellEditor getEditor(Item pair) {
            return new DefaultCellEditor((JComboBox<?>)new ComboBox((Object[])ExclusionScope.values()));
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item pair, ExclusionScope value) {
            pair.scope = value;
        }

        @Nullable
        public String getMaxStringValue() {
            return "Project";
        }
    };
    private final Project myProject;

    public ExcludeTable(@NotNull Project project2) {
        this.myProject = project2;
        this.getTableView().getEmptyText().setText(ApplicationBundle.message((String)"exclude.from.imports.no.exclusions", (Object[])new Object[0]));
    }

    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{NAME_COLUMN, SCOPE_COLUMN});
    }

    protected Item createElement() {
        return new Item("", ExclusionScope.IDE);
    }

    protected boolean isEmpty(Item element) {
        return element.exclude.isEmpty();
    }

    protected Item cloneElement(Item variable) {
        return new Item(variable.exclude, variable.scope);
    }

    protected boolean canDeleteElement(Item selection) {
        return true;
    }

    void addExcludePackage(String packageName) {
        int index;
        if (packageName == null) {
            return;
        }
        for (index = 0; index < this.getTableView().getListTableModel().getRowCount() && ((Item)this.getTableView().getListTableModel().getItem((int)index)).exclude.compareTo(packageName) <= 0; ++index) {
        }
        this.getTableView().getListTableModel().insertRow(index, (Object)new Item(packageName, ExclusionScope.IDE));
        this.getTableView().clearSelection();
        this.getTableView().addRowSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible((JTable)this.getTableView(), (int)index, (int)0);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTableView(), false);
    }

    void reset() {
        ArrayList rows = ContainerUtil.newArrayList();
        for (String s : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            rows.add(new Item(s, ExclusionScope.IDE));
        }
        for (String s : JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames) {
            rows.add(new Item(s, ExclusionScope.Project));
        }
        Collections.sort(rows, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.exclude.compareTo(o2.exclude);
            }
        });
        this.setValues(rows);
    }

    void apply() {
        CodeInsightSettings.getInstance().EXCLUDED_PACKAGES = ArrayUtil.toStringArray(this.getExcludedPackages(ExclusionScope.IDE));
        JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames = this.getExcludedPackages(ExclusionScope.Project);
    }

    private List<String> getExcludedPackages(ExclusionScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        for (Item pair : this.getTableView().getListTableModel().getItems()) {
            if (scope != pair.scope) continue;
            result.add(pair.exclude);
        }
        Collections.sort(result);
        return result;
    }

    boolean isModified() {
        return !this.getExcludedPackages(ExclusionScope.IDE).equals(Arrays.asList(CodeInsightSettings.getInstance().EXCLUDED_PACKAGES)) || !this.getExcludedPackages(ExclusionScope.Project).equals(JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames);
    }

    static class Item {
        String exclude;
        ExclusionScope scope;

        Item(@NotNull String exclude, ExclusionScope scope) {
            this.exclude = exclude;
            this.scope = scope;
        }
    }

    private static enum ExclusionScope {
        Project,
        IDE;

    }
}

