/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.editor.EditorSmartKeysConfigurableEP;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorSmartKeysConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.editor.EditorSmartKeysConfigurable");
    private static final ExtensionPointName<EditorSmartKeysConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorSmartKeysConfigurable");
    private JCheckBox myCbSmartHome;
    private JCheckBox myCbSmartEnd;
    private JCheckBox myCbInsertPairBracket;
    private JCheckBox myCbInsertPairQuote;
    private JCheckBox myCbCamelWords;
    private JCheckBox myCbSmartIndentOnEnter;
    private JComboBox myReformatOnPasteCombo;
    private JPanel myRootPanel;
    private JPanel myAddonPanel;
    private JCheckBox myCbInsertPairCurlyBraceOnEnter;
    private JCheckBox myCbInsertJavadocStubOnEnter;
    private JCheckBox myCbSurroundSelectionOnTyping;
    private JCheckBox myCbReformatBlockOnTypingRBrace;
    private JComboBox mySmartBackspaceCombo;
    private JCheckBox myCbEnableAddingCaretsOnDoubleCtrlArrows;
    private boolean myAddonsInitialized = false;
    private static final String NO_REFORMAT = ApplicationBundle.message((String)"combobox.paste.reformat.none", (Object[])new Object[0]);
    private static final String INDENT_BLOCK = ApplicationBundle.message((String)"combobox.paste.reformat.indent.block", (Object[])new Object[0]);
    private static final String INDENT_EACH_LINE = ApplicationBundle.message((String)"combobox.paste.reformat.indent.each.line", (Object[])new Object[0]);
    private static final String REFORMAT_BLOCK = ApplicationBundle.message((String)"combobox.paste.reformat.reformat.block", (Object[])new Object[0]);
    private static final String OFF = ApplicationBundle.message((String)"combobox.smart.backspace.off", (Object[])new Object[0]);
    private static final String SIMPLE = ApplicationBundle.message((String)"combobox.smart.backspace.simple", (Object[])new Object[0]);
    private static final String SMART = ApplicationBundle.message((String)"combobox.smart.backspace.smart", (Object[])new Object[0]);

    public EditorSmartKeysConfigurable() {
        this.$$$setupUI$$$();
        this.myReformatOnPasteCombo.addItem(NO_REFORMAT);
        this.myReformatOnPasteCombo.addItem(INDENT_BLOCK);
        this.myReformatOnPasteCombo.addItem(INDENT_EACH_LINE);
        this.myReformatOnPasteCombo.addItem(REFORMAT_BLOCK);
        this.mySmartBackspaceCombo.addItem(OFF);
        this.mySmartBackspaceCombo.addItem(SIMPLE);
        this.mySmartBackspaceCombo.addItem(SMART);
        this.myCbInsertJavadocStubOnEnter.setVisible(EditorSmartKeysConfigurable.hasAnyDocAwareCommenters());
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows.setText(ApplicationBundle.message((String)"checkbox.enable.double.ctrl", (Object[])new Object[]{KeyEvent.getKeyText(KeymapManagerImpl.getMultiCaretActionModifier())}));
    }

    private static boolean hasAnyDocAwareCommenters() {
        Collection languages = Language.getRegisteredLanguages();
        for (Language language : languages) {
            CodeDocumentationAwareCommenter docCommenter;
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (!(commenter instanceof CodeDocumentationAwareCommenter) || (docCommenter = (CodeDocumentationAwareCommenter)commenter).getDocumentationCommentLinePrefix() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<UnnamedConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    @Nls
    public String getDisplayName() {
        return "Smart Keys";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.smartkey";
    }

    public JComponent createComponent() {
        if (!this.myAddonsInitialized) {
            this.myAddonsInitialized = true;
            for (UnnamedConfigurable provider : this.getConfigurables()) {
                this.myAddonPanel.add((Component)provider.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 15, 0), 0, 0));
            }
        }
        return this.myRootPanel;
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        switch (codeInsightSettings.REFORMAT_ON_PASTE) {
            case 1: {
                this.myReformatOnPasteCombo.setSelectedItem(NO_REFORMAT);
                break;
            }
            case 2: {
                this.myReformatOnPasteCombo.setSelectedItem(INDENT_BLOCK);
                break;
            }
            case 3: {
                this.myReformatOnPasteCombo.setSelectedItem(INDENT_EACH_LINE);
                break;
            }
            case 4: {
                this.myReformatOnPasteCombo.setSelectedItem(REFORMAT_BLOCK);
            }
        }
        this.myCbSmartHome.setSelected(editorSettings.isSmartHome());
        this.myCbSmartEnd.setSelected(codeInsightSettings.SMART_END_ACTION);
        this.myCbSmartIndentOnEnter.setSelected(codeInsightSettings.SMART_INDENT_ON_ENTER);
        this.myCbInsertPairCurlyBraceOnEnter.setSelected(codeInsightSettings.INSERT_BRACE_ON_ENTER);
        this.myCbInsertJavadocStubOnEnter.setSelected(codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        this.myCbInsertPairBracket.setSelected(codeInsightSettings.AUTOINSERT_PAIR_BRACKET);
        this.myCbInsertPairQuote.setSelected(codeInsightSettings.AUTOINSERT_PAIR_QUOTE);
        this.myCbReformatBlockOnTypingRBrace.setSelected(codeInsightSettings.REFORMAT_BLOCK_ON_RBRACE);
        this.myCbCamelWords.setSelected(editorSettings.isCamelWords());
        this.myCbSurroundSelectionOnTyping.setSelected(codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED);
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows.setSelected(editorSettings.addCaretsOnDoubleCtrl());
        SmartBackspaceMode backspaceMode = codeInsightSettings.getBackspaceMode();
        switch (backspaceMode) {
            case OFF: {
                this.mySmartBackspaceCombo.setSelectedItem(OFF);
                break;
            }
            case INDENT: {
                this.mySmartBackspaceCombo.setSelectedItem(SIMPLE);
                break;
            }
            case AUTOINDENT: {
                this.mySmartBackspaceCombo.setSelectedItem(SMART);
                break;
            }
            default: {
                LOG.error("Unexpected smart backspace mode value: " + backspaceMode);
            }
        }
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        editorSettings.setSmartHome(this.myCbSmartHome.isSelected());
        codeInsightSettings.SMART_END_ACTION = this.myCbSmartEnd.isSelected();
        codeInsightSettings.SMART_INDENT_ON_ENTER = this.myCbSmartIndentOnEnter.isSelected();
        codeInsightSettings.INSERT_BRACE_ON_ENTER = this.myCbInsertPairCurlyBraceOnEnter.isSelected();
        codeInsightSettings.JAVADOC_STUB_ON_ENTER = this.myCbInsertJavadocStubOnEnter.isSelected();
        codeInsightSettings.AUTOINSERT_PAIR_BRACKET = this.myCbInsertPairBracket.isSelected();
        codeInsightSettings.AUTOINSERT_PAIR_QUOTE = this.myCbInsertPairQuote.isSelected();
        codeInsightSettings.REFORMAT_BLOCK_ON_RBRACE = this.myCbReformatBlockOnTypingRBrace.isSelected();
        codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED = this.myCbSurroundSelectionOnTyping.isSelected();
        editorSettings.setCamelWords(this.myCbCamelWords.isSelected());
        codeInsightSettings.REFORMAT_ON_PASTE = this.getReformatPastedBlockValue();
        codeInsightSettings.setBackspaceMode(this.getSmartBackspaceModeValue());
        editorSettings.setAddCaretsOnDoubleCtrl(this.myCbEnableAddingCaretsOnDoubleCtrlArrows.isSelected());
        super.apply();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = this.getReformatPastedBlockValue() != codeInsightSettings.REFORMAT_ON_PASTE;
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartHome, editorSettings.isSmartHome());
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartEnd, codeInsightSettings.SMART_END_ACTION);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartIndentOnEnter, codeInsightSettings.SMART_INDENT_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairCurlyBraceOnEnter, codeInsightSettings.INSERT_BRACE_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertJavadocStubOnEnter, codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairBracket, codeInsightSettings.AUTOINSERT_PAIR_BRACKET);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairQuote, codeInsightSettings.AUTOINSERT_PAIR_QUOTE);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbReformatBlockOnTypingRBrace, codeInsightSettings.REFORMAT_BLOCK_ON_RBRACE);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbCamelWords, editorSettings.isCamelWords());
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSurroundSelectionOnTyping, codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbEnableAddingCaretsOnDoubleCtrlArrows, editorSettings.addCaretsOnDoubleCtrl());
        return isModified |= this.getSmartBackspaceModeValue() != codeInsightSettings.getBackspaceMode();
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private int getReformatPastedBlockValue() {
        Object selectedItem = this.myReformatOnPasteCombo.getSelectedItem();
        if (NO_REFORMAT.equals(selectedItem)) {
            return 1;
        }
        if (INDENT_BLOCK.equals(selectedItem)) {
            return 2;
        }
        if (INDENT_EACH_LINE.equals(selectedItem)) {
            return 3;
        }
        if (REFORMAT_BLOCK.equals(selectedItem)) {
            return 4;
        }
        LOG.assertTrue(false);
        return -1;
    }

    private SmartBackspaceMode getSmartBackspaceModeValue() {
        Object selectedItem = this.mySmartBackspaceCombo.getSelectedItem();
        if (OFF.equals(selectedItem)) {
            return SmartBackspaceMode.OFF;
        }
        if (SIMPLE.equals(selectedItem)) {
            return SmartBackspaceMode.INDENT;
        }
        if (SMART.equals(selectedItem)) {
            return SmartBackspaceMode.AUTOINDENT;
        }
        LOG.error("Unexpected smart backspace item value: " + selectedItem);
        return SmartBackspaceMode.OFF;
    }

    @NotNull
    public String getId() {
        return "editor.preferences.smartKeys";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel;
        JComboBox jComboBox2;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbSmartHome = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.home"));
        jCheckBox11.setSelected(true);
        jPanel2.add((Component)jCheckBox11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbSmartEnd = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.end.on.blank.line"));
        jCheckBox10.setSelected(true);
        jPanel2.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairBracket = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.bracket"));
        jCheckBox9.setSelected(true);
        jPanel2.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairQuote = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.quote"));
        jCheckBox8.setSelected(true);
        jPanel2.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCamelWords = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.camelhumps.words"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(10, 0, 1, 2, 1, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.paste.reformat"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReformatOnPasteCombo = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddonPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(11, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCbReformatBlockOnTypingRBrace = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.reformat.on.typing.rbrace"));
        jCheckBox6.setSelected(true);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbSurroundSelectionOnTyping = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Surround selection on typing quote or brace");
        jPanel2.add((Component)jCheckBox5, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Backspace", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.smart.backspace"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySmartBackspaceCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel5, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Enter", (int)0, (int)0, null, null));
        this.myCbSmartIndentOnEnter = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.indent"));
        jCheckBox4.setSelected(true);
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairCurlyBraceOnEnter = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.curly.brace"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertJavadocStubOnEnter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.javadoc.stub.after.slash.star.star"));
        jCheckBox2.setSelected(true);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.double.ctrl"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

