/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class FontEditorPreview
implements PreviewPanel {
    private final EditorEx myEditor;
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    FontEditorPreview(ColorAndFontOptions options, boolean editable) {
        this.myOptions = options;
        String text = FontEditorPreview.getIDEDemoText();
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text, 10, 3, -1, this.myOptions, editable);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    public static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is a full-featured IDE\n" + "with a high level of usability and outstanding\n" + "advanced code editing and refactoring support.\n" + "\n" + "abcdefghijklmnopqrstuvwxyz 0123456789 (){}[]\n" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/= .,;:!? #&$%@|^\n" + "\n" + "\n" + "\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        TrafficLightRenderer renderer = new TrafficLightRenderer(null, null, null){

            @Override
            @NotNull
            protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
                TrafficLightRenderer.DaemonCodeAnalyzerStatus status = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
                status.errorAnalyzingFinished = true;
                status.errorCount = new int[]{1, 2};
                return status;
            }
        };
        Disposer.register((Disposable)((Disposable)editor.getCaretModel()), (Disposable)renderer);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeRenderer(renderer);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text, int column, int line, int selectedLine, ColorAndFontOptions options, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(options.getSelectedScheme());
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        LogicalPosition pos = new LogicalPosition(line, column);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (selectedLine >= 0) {
            editor.getSelectionModel().setSelection(editorDocument.getLineStartOffset(selectedLine), editorDocument.getLineEndOffset(selectedLine));
        }
        return editor;
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.updateOptionsScheme(this.myOptions.getSelectedScheme());
        this.myEditor.setColorsScheme(scheme);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
    }
}

