/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorOptionsTree
extends Tree {
    private final String myCategoryName;
    private final DefaultTreeModel myTreeModel = (DefaultTreeModel)this.getModel();
    public static final String NAME_SEPARATOR = "//";
    private static final Comparator<EditorSchemeAttributeDescriptor> ATTR_COMPARATOR = new Comparator<EditorSchemeAttributeDescriptor>(){

        @Override
        public int compare(EditorSchemeAttributeDescriptor o1, EditorSchemeAttributeDescriptor o2) {
            return StringUtil.naturalCompare((String)o1.toString(), (String)o2.toString());
        }
    };

    public ColorOptionsTree(@NotNull String categoryName) {
        super(ColorOptionsTree.createTreeModel());
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.myCategoryName = categoryName;
        new TreeSpeedSearch(this, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
    }

    public void fillOptions(@NotNull ColorAndFontOptions options) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (EditorSchemeAttributeDescriptor description : this.getOrderedDescriptors(options)) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            List<String> path = ColorOptionsTree.extractPath(description);
            if (path != null && path.size() > 1) {
                MyTreeNode groupNode = ColorOptionsTree.ensureGroup(root, path, 0);
                groupNode.add(new MyTreeNode(description, path.get(path.size() - 1)));
                continue;
            }
            root.add(new MyTreeNode(description));
        }
        this.myTreeModel.setRoot(root);
    }

    private static TreeModel createTreeModel() {
        return new DefaultTreeModel((TreeNode)new DefaultMutableTreeTableNode());
    }

    private Collection<EditorSchemeAttributeDescriptor> getOrderedDescriptors(@NotNull ColorAndFontOptions options) {
        ArrayList list = ContainerUtil.newArrayList();
        for (EditorSchemeAttributeDescriptor description : options.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            list.add(description);
        }
        Collections.sort(list, ATTR_COMPARATOR);
        return list;
    }

    @Nullable
    public ColorAndFontDescription getSelectedDescriptor() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue instanceof ColorAndFontDescription ? (ColorAndFontDescription)selectedValue : null;
    }

    @Nullable
    public Object getSelectedValue() {
        Object selectedNode = this.getLastSelectedPathComponent();
        if (selectedNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)selectedNode).getUserObject();
        }
        return null;
    }

    public void selectOptionByType(final @NotNull String attributeType) {
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                if (data instanceof EditorSchemeAttributeDescriptor) {
                    return attributeType.equals(((EditorSchemeAttributeDescriptor)data).getType());
                }
                return false;
            }
        }));
    }

    public void selectOptionByName(final @NotNull String optionName) {
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                return !optionName.isEmpty() && StringUtil.containsIgnoreCase((String)data.toString(), (String)optionName);
            }
        }));
    }

    @Nullable
    private TreePath findOption(@NotNull Object nodeObject, @NotNull DescriptorMatcher matcher) {
        for (int i = 0; i < this.myTreeModel.getChildCount(nodeObject); ++i) {
            Object data;
            Object childObject = this.myTreeModel.getChild(nodeObject, i);
            if (childObject instanceof MyTreeNode && matcher.matches(data = ((MyTreeNode)childObject).getUserObject())) {
                return new TreePath(this.myTreeModel.getPathToRoot((MyTreeNode)childObject));
            }
            TreePath pathInChild = this.findOption(childObject, matcher);
            if (pathInChild == null) continue;
            return pathInChild;
        }
        return null;
    }

    private void selectPath(@Nullable TreePath path) {
        if (path != null) {
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static List<String> extractPath(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor instanceof ColorAndFontDescription) {
            String name = descriptor.toString();
            ArrayList<String> path = new ArrayList<String>();
            int separatorStart = name.indexOf(NAME_SEPARATOR);
            int nextChunkStart = 0;
            while (separatorStart > 0) {
                path.add(name.substring(nextChunkStart, separatorStart));
                nextChunkStart = separatorStart + NAME_SEPARATOR.length();
                separatorStart = name.indexOf(NAME_SEPARATOR, nextChunkStart);
            }
            if (nextChunkStart < name.length()) {
                path.add(name.substring(nextChunkStart));
            }
            return path;
        }
        return null;
    }

    private static MyTreeNode ensureGroup(@NotNull DefaultMutableTreeNode root, @NotNull List<String> path, int index) {
        String groupName = path.get(index++);
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode child = root.getChildAt(i);
            if (!(child instanceof MyTreeNode) || !groupName.equals(child.toString())) continue;
            return index < path.size() - 1 ? ColorOptionsTree.ensureGroup((MyTreeNode)child, path, index) : (MyTreeNode)child;
        }
        MyTreeNode groupNode = new MyTreeNode(groupName);
        root.add(groupNode);
        return index < path.size() - 1 ? ColorOptionsTree.ensureGroup(groupNode, path, index) : groupNode;
    }

    private static interface DescriptorMatcher {
        public boolean matches(@NotNull Object var1);
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final String myName;

        public MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor, @NotNull String name) {
            super(descriptor);
            this.myName = name;
        }

        public MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor) {
            super(descriptor);
            this.myName = descriptor.toString();
        }

        public MyTreeNode(@NotNull String groupName) {
            super(groupName);
            this.myName = groupName;
        }

        @Override
        public String toString() {
            return this.myName;
        }
    }
}

