/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TitleWithToolbar
extends JPanel {
    public TitleWithToolbar(@NotNull String title, @NotNull String actionGroupId, @NotNull String place, @NotNull JComponent targetComponent) {
        super(new GridBagLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction(actionGroupId);
        ActionToolbar actionToolbar = actionManager.createActionToolbar(place, group, true);
        actionToolbar.setTargetComponent(targetComponent);
        actionToolbar.setLayoutPolicy(0);
        this.add((Component)new MyTitleComponent(title), new GridBag().weightx(1.0).anchor(17).fillCellHorizontally());
        this.add((Component)actionToolbar.getComponent(), new GridBag().anchor(10));
    }

    private class MyTitleComponent
    extends JComponent {
        private final Dimension myMinimumSize;
        @NotNull
        private final Border myBorder;

        MyTitleComponent(String title) {
            this.myBorder = IdeBorderFactory.createTitledBorder((String)title);
            Insets insets = this.myBorder.getBorderInsets(TitleWithToolbar.this);
            this.myMinimumSize = new Dimension(1, insets.top);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myMinimumSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.myMinimumSize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = this.getBounds();
            this.myBorder.paintBorder(this, g, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

