/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.animation.ArrangementAnimationManager;
import com.intellij.application.options.codeStyle.arrangement.animation.ArrangementAnimationPanel;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.component.ArrangementAndMatchConditionComponent;
import com.intellij.application.options.codeStyle.arrangement.component.ArrangementAtomMatchConditionComponent;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.util.Consumer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchNodeComponentFactory {
    private static final Logger LOG = Logger.getInstance((String)("#" + ArrangementMatchNodeComponentFactory.class.getName()));
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final ArrangementMatchingRulesControl myList;

    public ArrangementMatchNodeComponentFactory(@NotNull ArrangementStandardSettingsManager manager, @NotNull ArrangementColorsProvider provider, @NotNull ArrangementMatchingRulesControl list) {
        this.mySettingsManager = manager;
        this.myColorsProvider = provider;
        this.myList = list;
    }

    @NotNull
    public ArrangementUiComponent getComponent(@NotNull ArrangementMatchCondition rendererTarget, final @NotNull StdArrangementMatchRule rule, final boolean allowModification) {
        final Ref ref = new Ref();
        rendererTarget.invite(new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                RemoveAtomConditionCallback callback = allowModification ? new RemoveAtomConditionCallback(rule) : null;
                ArrangementAtomMatchConditionComponent component = new ArrangementAtomMatchConditionComponent(ArrangementMatchNodeComponentFactory.this.mySettingsManager, ArrangementMatchNodeComponentFactory.this.myColorsProvider, condition, callback);
                ref.set((Object)component);
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                ref.set((Object)new ArrangementAndMatchConditionComponent(rule, condition, ArrangementMatchNodeComponentFactory.this, ArrangementMatchNodeComponentFactory.this.mySettingsManager, allowModification));
            }
        });
        return (ArrangementUiComponent)ref.get();
    }

    private static class DummyElement {
        private DummyElement() {
        }

        public String toString() {
            return "dummy-" + System.identityHashCode(this);
        }
    }

    private class RemoveAtomConditionCallback
    implements Consumer<ArrangementAtomMatchConditionComponent>,
    ArrangementAnimationManager.Callback {
        @NotNull
        private final StdArrangementMatchRule myRule;
        @NotNull
        private Object myModelValue;
        private int myRow;

        RemoveAtomConditionCallback(StdArrangementMatchRule rule) {
            this.myRule = rule;
            this.myModelValue = this.myRule;
        }

        public void consume(@NotNull ArrangementAtomMatchConditionComponent component) {
            ArrangementAtomMatchCondition condition = component.getMatchCondition();
            ArrangementMatchingRulesModel model = ArrangementMatchNodeComponentFactory.this.myList.getModel();
            int i = this.getModelIndex();
            if (i < 0) {
                return;
            }
            this.myRow = i;
            ArrangementMatchCondition existingCondition = this.myRule.getMatcher().getCondition();
            if (existingCondition.equals(condition)) {
                this.myModelValue = new DummyElement();
                model.set(i, this.myModelValue);
            } else {
                assert (existingCondition instanceof ArrangementCompositeMatchCondition);
                Set operands = ((ArrangementCompositeMatchCondition)existingCondition).getOperands();
                operands.remove(condition);
                if (operands.isEmpty()) {
                    this.myModelValue = new DummyElement();
                    model.set(i, this.myModelValue);
                } else if (operands.size() == 1) {
                    this.myModelValue = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)operands.iterator().next()), this.myRule.getOrderType());
                    model.set(i, this.myModelValue);
                } else if (ArrangementConstants.LOG_RULE_MODIFICATION) {
                    LOG.info(String.format("Removed '%s' condition. Current rule state: %s", condition, this.myRule));
                    this.myModelValue = this.myRule;
                }
            }
            ArrangementAnimationPanel panel = component.getAnimationPanel();
            new ArrangementAnimationManager(panel, this).startAnimation();
        }

        @Override
        public void onAnimationIteration(boolean finished) {
            this.refreshRow();
            if (this.myRow < 0) {
                return;
            }
            ArrangementMatchNodeComponentFactory.this.myList.repaintRows(this.myRow, this.myRow, finished);
            if (!finished) {
                return;
            }
            if (this.myModelValue instanceof DummyElement) {
                ArrangementMatchNodeComponentFactory.this.myList.removeRow(this.myRow);
            }
        }

        private void refreshRow() {
            ArrangementMatchingRulesModel model = ArrangementMatchNodeComponentFactory.this.myList.getModel();
            if (this.myRow < 0 || this.myRow >= model.getSize()) {
                this.myRow = this.getModelIndex();
            } else {
                Object o = model.getElementAt(this.myRow);
                if (o != this.myModelValue) {
                    this.myRow = this.getModelIndex();
                }
            }
        }

        private int getModelIndex() {
            ArrangementMatchingRulesModel model = ArrangementMatchNodeComponentFactory.this.myList.getModel();
            int max = model.getSize();
            for (int i = 0; i < max; ++i) {
                if (model.getElementAt(i) != this.myModelValue) continue;
                return i;
            }
            return -1;
        }
    }
}

