/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Alarm;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ArrangementTextFieldUiComponent
extends AbstractArrangementUiComponent {
    @NotNull
    private final JBTextField myTextField = new JBTextField(20);
    @NotNull
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    @NotNull
    private final ArrangementSettingsToken myToken;

    public ArrangementTextFieldUiComponent(@NotNull ArrangementSettingsToken token) {
        super(token);
        this.myToken = token;
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }
        });
    }

    private void scheduleUpdate() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ArrangementTextFieldUiComponent.this.fireStateChanged();
            }
        }, 1000);
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        return this.myToken;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        String text = this.myTextField.getText();
        return new ArrangementAtomMatchCondition(this.myToken, (Object)(StringUtil.isEmpty((String)text) ? "" : text.trim()));
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myTextField;
    }

    public boolean isSelected() {
        return !StringUtil.isEmpty((String)this.myTextField.getText());
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public boolean isEnabled() {
        return this.myTextField.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTextField.setEnabled(enabled);
    }

    @Override
    public void setData(@NotNull Object data) {
        if (data instanceof String) {
            this.myTextField.setText(data.toString());
        }
    }

    @Override
    public void doReset() {
        this.myTextField.setText("");
    }

    public int getBaselineToUse(int width, int height) {
        return this.myTextField.getBaseline(width, height);
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }
}

