/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CodeStyleSchemeExporterUI {
    @NotNull
    private final Component myParentComponent;
    @NotNull
    private final CodeStyleScheme myScheme;
    @NotNull
    private final StatusCallback myStatusCallback;

    CodeStyleSchemeExporterUI(@NotNull Component parentComponent, @NotNull CodeStyleScheme scheme, @NotNull StatusCallback statusCallback) {
        this.myParentComponent = parentComponent;
        this.myScheme = scheme;
        this.myStatusCallback = statusCallback;
    }

    void export() {
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(ApplicationBundle.message((String)"scheme.exporter.ui.export.as.title", (Object[])new Object[0]), CodeStyleSchemeExporterUI.enumExporters()){

            public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleSchemeExporterUI.this.exportSchemeUsing(selectedValue);
                    }
                });
            }
        });
        popup.showInCenterOf(this.myParentComponent);
    }

    private static String[] enumExporters() {
        ArrayList<String> names = new ArrayList<String>();
        Collection<SchemeExporterEP<CodeStyleScheme>> extensions = SchemeExporterEP.getExtensions(CodeStyleScheme.class);
        for (SchemeExporterEP<CodeStyleScheme> extension : extensions) {
            names.add(extension.name);
        }
        return ArrayUtil.toStringArray(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSchemeUsing(@NotNull String exporterName) {
        SchemeExporter<CodeStyleScheme> exporter = SchemeExporterEP.getExporter(exporterName, CodeStyleScheme.class);
        if (exporter != null) {
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), new String[]{ext}), this.myParentComponent);
            VirtualFileWrapper target = saver.save(null, this.getFileNameSuggestion() + "." + ext);
            if (target != null) {
                MessageType messageType;
                String message;
                VirtualFile targetFile = target.getVirtualFile(true);
                if (targetFile != null) {
                    AccessToken writeToken = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
                    try {
                        try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                            exporter.exportScheme((Scheme)this.myScheme, outputStream);
                        }
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.code.style.exported.message", (Object[])new Object[]{this.myScheme.getName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e) {
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                    finally {
                        writeToken.finish();
                    }
                } else {
                    message = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.myStatusCallback.showMessage(message, messageType);
            }
        }
    }

    private String getFileNameSuggestion() {
        return this.myScheme.getName();
    }

    static interface StatusCallback {
        public void showMessage(@NotNull String var1, @NotNull MessageType var2);
    }
}

