/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesComboBox
extends ComboBox {
    private final SortedComboBoxModel<Module> myModel;
    private boolean myAllowEmptySelection;

    public ModulesComboBox() {
        this((SortedComboBoxModel<Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
    }

    private ModulesComboBox(SortedComboBoxModel<Module> model) {
        super(model);
        this.myModel = model;
        new ComboboxSpeedSearch((JComboBox)((Object)this)){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return "";
                }
                return super.getElementText(element);
            }
        };
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
    }

    public void allowEmptySelection(@NotNull String emptySelectionText) {
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<Module> modules) {
        this.myModel.setAll(modules);
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void fillModules(@NotNull Project project2) {
        this.fillModules(project2, null);
    }

    public void fillModules(@NotNull Project project2, @Nullable ModuleType moduleType) {
        Module[] allModules = ModuleManager.getInstance((Project)project2).getModules();
        if (moduleType == null) {
            this.setModules(Arrays.asList(allModules));
        } else {
            ArrayList<Module> modules = new ArrayList<Module>();
            for (Module module2 : allModules) {
                if (!moduleType.equals((Object)ModuleType.get((Module)module2))) continue;
                modules.add(module2);
            }
            this.setModules(modules);
        }
    }

    public void setSelectedModule(@Nullable Module module2) {
        this.myModel.setSelectedItem((Object)module2);
    }

    @Nullable
    public Module getSelectedModule() {
        return (Module)this.myModel.getSelectedItem();
    }
}

