/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.CommonBundle;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.ide.actions.CreateLauncherScriptAction;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.ui.LafComboBoxRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class InitialConfigurationDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JComboBox myKeymapComboBox;
    private JComboBox myColorSchemeComboBox;
    private JCheckBox myCreateScriptCheckbox;
    private JTextField myScriptPathTextField;
    private JPanel myCreateScriptPanel;
    private JPanel myColorPreviewPanel;
    private JPanel myHeaderPanel;
    private JPanel myFooterPanel;
    private JPanel myExtraOptionsPanel;
    private JCheckBox myCreateEntryCheckBox;
    private JCheckBox myGlobalEntryCheckBox;
    private JPanel myCreateEntryPanel;
    private ComboBox myAppearanceComboBox;
    private JLabel myPreferencesLabel;
    private final String myColorSettingsPage;
    private SimpleEditorPreview myPreviewEditor;
    private ColorAndFontOptions myPreviewOptions;
    private MyColorPreviewPanel myHidingPreviewPanel;
    private NewColorAndFontPanel myColorAndFontPanel;

    public InitialConfigurationDialog(Component parent, String colorSettingsPage) {
        super(parent, true);
        this.myColorSettingsPage = colorSettingsPage;
        this.$$$setupUI$$$();
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " Initial Configuration");
        ArrayList<Keymap> keymaps = new ArrayList<Keymap>();
        for (Keymap keymap : ((KeymapManagerImpl)KeymapManager.getInstance()).getAllKeymaps()) {
            if (!InitialConfigurationDialog.matchesPlatform(keymap)) continue;
            keymaps.add(keymap);
        }
        this.myAppearanceComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LafManager.getInstance().getInstalledLookAndFeels()));
        this.myAppearanceComboBox.setRenderer((ListCellRenderer)((Object)new LafComboBoxRenderer()));
        this.myAppearanceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InitialConfigurationDialog.this.preselectColorScheme();
            }
        });
        this.myAppearanceComboBox.setSelectedItem((Object)LafManager.getInstance().getCurrentLookAndFeel());
        this.myColorSchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditorColorsScheme scheme = (EditorColorsScheme)InitialConfigurationDialog.this.myColorSchemeComboBox.getSelectedItem();
                if (scheme.getName().equals("Darcula")) {
                    UIManager.LookAndFeelInfo[] lafs;
                    for (UIManager.LookAndFeelInfo laf : lafs = LafManager.getInstance().getInstalledLookAndFeels()) {
                        if (!laf.getName().contains("Darcula")) continue;
                        InitialConfigurationDialog.this.myAppearanceComboBox.setSelectedItem((Object)laf);
                        break;
                    }
                }
            }
        });
        this.myKeymapComboBox.setModel(new DefaultComboBoxModel<Keymap>(keymaps.toArray(new Keymap[keymaps.size()])));
        this.myKeymapComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
                Keymap keymap = (Keymap)value;
                if (keymap == null) {
                    return;
                }
                if ("$default".equals(keymap.getName())) {
                    this.setText("IntelliJ IDEA Classic");
                } else if ("Mac OS X".equals(keymap.getName())) {
                    this.setText("IntelliJ IDEA Classic - Mac OS X");
                } else {
                    this.setText(keymap.getPresentableName());
                }
            }
        });
        this.preselectKeyMap(keymaps);
        EditorColorsScheme[] colorSchemes = EditorColorsManager.getInstance().getAllSchemes();
        this.myColorSchemeComboBox.setModel(new DefaultComboBoxModel<EditorColorsScheme>(colorSchemes));
        this.myColorSchemeComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
                if (value != null) {
                    this.setText(((EditorColorsScheme)value).getName());
                }
            }
        });
        this.myColorSchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InitialConfigurationDialog.this.myHidingPreviewPanel != null) {
                    InitialConfigurationDialog.this.myHidingPreviewPanel.updateColorSchemePreview(true);
                }
            }
        });
        this.preselectColorScheme();
        this.setResizable(false);
        this.setCancelButtonText("Skip");
        this.init();
        boolean canCreateLauncherScript = this.canCreateLauncherScript();
        this.myCreateScriptCheckbox.setVisible(canCreateLauncherScript);
        this.myCreateScriptCheckbox.setSelected(canCreateLauncherScript);
        this.myCreateScriptPanel.setVisible(canCreateLauncherScript);
        if (canCreateLauncherScript) {
            this.myScriptPathTextField.setText(CreateLauncherScriptAction.defaultScriptPath());
        }
        boolean canCreateDesktopEntry = this.canCreateDesktopEntry();
        this.myCreateEntryCheckBox.setVisible(canCreateDesktopEntry);
        this.myCreateEntryCheckBox.setSelected(canCreateDesktopEntry);
        this.myCreateEntryPanel.setVisible(canCreateDesktopEntry);
        if (canCreateDesktopEntry) {
            this.myGlobalEntryCheckBox.setSelected(!PathManager.getHomePath().startsWith("/home"));
        }
        this.myPreferencesLabel.setText("You can use " + CommonBundle.settingsActionPath() + " to configure any of these settings later.");
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                InitialConfigurationDialog.this.disposeUIResources();
            }
        });
    }

    private void preselectColorScheme() {
        UIManager.LookAndFeelInfo selectedLaf = (UIManager.LookAndFeelInfo)this.myAppearanceComboBox.getSelectedItem();
        if (!selectedLaf.getName().contains("Darcula")) {
            this.myColorSchemeComboBox.setSelectedItem(EditorColorsManager.getInstance().getScheme("Default"));
        }
    }

    private void disposeUIResources() {
        if (this.myPreviewEditor != null) {
            this.myPreviewEditor.disposeUIResources();
        }
        if (this.myPreviewOptions != null) {
            this.myPreviewOptions.disposeUIResources();
        }
        if (this.myColorAndFontPanel != null) {
            this.myColorAndFontPanel.disposeUIResources();
        }
    }

    protected boolean canCreateDesktopEntry() {
        return CreateDesktopEntryAction.isAvailable();
    }

    protected boolean canCreateLauncherScript() {
        return CreateLauncherScriptAction.isAvailable();
    }

    public JComboBox getKeymapComboBox() {
        return this.myKeymapComboBox;
    }

    public JComboBox getColorSchemeComboBox() {
        return this.myColorSchemeComboBox;
    }

    public ComboBox getAppearanceComboBox() {
        return this.myAppearanceComboBox;
    }

    private void preselectKeyMap(ArrayList<Keymap> keymaps) {
        Keymap defaultKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Keymap keymap : keymaps) {
            if (!(SystemInfo.isMac ? keymap.getName().contains("10.5+") : keymap.equals(defaultKeymap))) continue;
            this.myKeymapComboBox.setSelectedItem(keymap);
            break;
        }
    }

    private void createUIComponents() {
        this.myHeaderPanel = this.createHeaderPanel();
        this.myFooterPanel = this.createFooterPanel();
        this.myExtraOptionsPanel = this.createExtraOptionsPanel();
        this.myColorPreviewPanel = new AbstractTitledSeparatorWithIcon(AllIcons.General.ComboArrowRight, AllIcons.General.ComboArrowDown, "Click to preview"){
            private int myAddedWidth;

            @Override
            protected RefreshablePanel createPanel() {
                InitialConfigurationDialog.this.myHidingPreviewPanel = new MyColorPreviewPanel(this.myWrapper);
                return InitialConfigurationDialog.this.myHidingPreviewPanel;
            }

            @Override
            protected void initOnImpl() {
            }

            @Override
            protected void onImpl() {
                this.myWrapper.setVisible(true);
                this.setText("Click to hide preview");
                this.initDetails();
                this.myLabel.setIcon(this.myIconOpen);
                this.myOn = true;
                InitialConfigurationDialog dialog = InitialConfigurationDialog.this;
                this.revalidate();
                this.myAddedWidth = this.getPreferredSize().width - this.getSize().width;
                InitialConfigurationDialog.this.resizeTo(dialog.getSize().width + this.myAddedWidth, dialog.getSize().height + InitialConfigurationDialog.this.getPreviewPreferredHeight());
            }

            @Override
            protected void offImpl() {
                this.myLabel.setIcon(this.myIcon);
                this.setText("Click to preview");
                InitialConfigurationDialog dialog = InitialConfigurationDialog.this;
                InitialConfigurationDialog.this.resizeTo(dialog.getSize().width - this.myAddedWidth, dialog.getSize().height - InitialConfigurationDialog.this.getPreviewPreferredHeight());
                this.myWrapper.removeAll();
                this.myWrapper.setVisible(false);
                this.myOn = false;
            }
        };
    }

    private int getPreviewPreferredHeight() {
        return this.myPreviewEditor.getPanel().getPreferredSize().height / 2;
    }

    protected JPanel createFooterPanel() {
        JPanel panel = new JPanel();
        panel.setVisible(false);
        return panel;
    }

    protected JPanel createHeaderPanel() {
        JPanel panel = new JPanel();
        panel.setVisible(false);
        return panel;
    }

    protected JPanel createExtraOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setVisible(false);
        return panel;
    }

    private void resizeTo(int newWidth, int newHeight) {
        this.setSize(newWidth, newHeight);
        this.getRootPane().revalidate();
        this.getRootPane().repaint();
    }

    private static boolean matchesPlatform(Keymap keymap) {
        String name = keymap.getName();
        if ("$default".equals(name)) {
            return SystemInfo.isWindows;
        }
        if ("Mac OS X".equals(name) || "Mac OS X 10.5+".equals(name)) {
            return SystemInfo.isMac;
        }
        if ("Default for XWin".equals(name) || "Default for GNOME".equals(name) || "Default for KDE".equals(name)) {
            return SystemInfo.isXWindow;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
        super.doOKAction();
        ((KeymapManagerImpl)KeymapManager.getInstance()).setActiveKeymap((Keymap)this.myKeymapComboBox.getSelectedItem());
        EditorColorsManager.getInstance().setGlobalScheme((EditorColorsScheme)this.myColorSchemeComboBox.getSelectedItem());
        TodoConfiguration.getInstance().resetToDefaultTodoPatterns();
        final boolean createScript = this.myCreateScriptCheckbox.isSelected();
        final boolean createEntry = this.myCreateEntryCheckBox.isSelected();
        if (createScript || createEntry) {
            final String pathName = this.myScriptPathTextField.getText();
            final boolean globalEntry = this.myGlobalEntryCheckBox.isSelected();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, this.getTitle()){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicator.setFraction(0.0);
                    if (createScript) {
                        indicator.setText("Creating launcher script...");
                        try {
                            CreateLauncherScriptAction.createLauncherScript(pathName);
                        }
                        catch (Exception e) {
                            CreateLauncherScriptAction.reportFailure(e, this.getProject());
                        }
                    }
                    indicator.setFraction(0.5);
                    if (createEntry) {
                        indicator.setText("Creating desktop entry...");
                        try {
                            CreateDesktopEntryAction.createDesktopEntry(globalEntry);
                        }
                        catch (Exception e) {
                            CreateDesktopEntryAction.reportFailure(e, this.getProject());
                        }
                    }
                    indicator.setFraction(1.0);
                }
            });
        }
        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)this.myAppearanceComboBox.getSelectedItem();
        LafManagerImpl lafManager = (LafManagerImpl)LafManager.getInstance();
        if (info.getName().contains("Darcula") != LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo) {
            lafManager.setLookAndFeelAfterRestart(info);
            String message = "IDE appearance settings will be applied after restart. Would you like to restart now?";
            int rc = Messages.showYesNoDialog((Project)project2, (String)message, (String)"IDE Appearance", (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                ((ApplicationImpl)ApplicationManager.getApplication()).restart(true);
            }
        } else if (!info.equals(lafManager.getCurrentLookAndFeel())) {
            lafManager.setCurrentLookAndFeel(info);
            lafManager.updateUI();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        ComboBox comboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Keymap scheme:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Editor colors and fonts:");
        jPanel3.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeymapComboBox = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myColorSchemeComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCreateScriptCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable opening files and projects from the command line");
        jCheckBox3.setSelected(false);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateScriptPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Script path:");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptPathTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateEntryCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Create desktop entry (integrate in system menu)");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateEntryPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2));
        this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("For all  users");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("IDE theme:");
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppearanceComboBox = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel4 = this.myHeaderPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myFooterPanel;
        jPanel3.add((Component)jPanel5, new GridConstraints(11, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPreferencesLabel = jLabel = new JLabel();
        jLabel.setText("");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 11));
        }
        jPanel3.add((Component)jLabel, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel6 = this.myExtraOptionsPanel;
        jPanel3.add((Component)jPanel6, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = this.myColorPreviewPanel;
        jPanel3.add((Component)jPanel7, new GridConstraints(4, 0, 1, 2, 0, 3, 7, 7, null, null, null, 1));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class MyColorPreviewPanel
    extends JPanel
    implements RefreshablePanel {
        private final JPanel myWrapper;

        public MyColorPreviewPanel(JPanel wrapper) {
            super(new BorderLayout());
            this.myWrapper = wrapper;
            this.updateColorSchemePreview(false);
        }

        @Override
        public boolean refreshDataSynch() {
            return false;
        }

        @Override
        public void dataChanged() {
        }

        public boolean isStillValid(Object o) {
            return false;
        }

        @Override
        public void refresh() {
            this.updateColorSchemePreview(false);
        }

        @Override
        public JPanel getPanel() {
            return (JPanel)InitialConfigurationDialog.this.myPreviewEditor.getPanel();
        }

        @Override
        public void away() {
        }

        public void dispose() {
            InitialConfigurationDialog.this.disposeUIResources();
        }

        public void updateColorSchemePreview(boolean recalculateDialogSize) {
            if (!this.myWrapper.isVisible()) {
                return;
            }
            int wrapperHeight = 0;
            if (InitialConfigurationDialog.this.myPreviewEditor != null) {
                wrapperHeight = InitialConfigurationDialog.this.getPreviewPreferredHeight();
                InitialConfigurationDialog.this.myPreviewEditor.disposeUIResources();
                this.myWrapper.removeAll();
            }
            if (InitialConfigurationDialog.this.myPreviewOptions == null) {
                InitialConfigurationDialog.this.myPreviewOptions = new ColorAndFontOptions();
            }
            InitialConfigurationDialog.this.myPreviewOptions.reset();
            InitialConfigurationDialog.this.myPreviewOptions.selectScheme(((EditorColorsScheme)InitialConfigurationDialog.this.myColorSchemeComboBox.getSelectedItem()).getName());
            InitialConfigurationDialog.this.myColorAndFontPanel = InitialConfigurationDialog.this.myPreviewOptions.findPage(InitialConfigurationDialog.this.myColorSettingsPage);
            assert (InitialConfigurationDialog.this.myColorAndFontPanel != null);
            InitialConfigurationDialog.this.myPreviewEditor = new SimpleEditorPreview(InitialConfigurationDialog.this.myPreviewOptions, InitialConfigurationDialog.this.myColorAndFontPanel.getSettingsPage(), false);
            InitialConfigurationDialog.this.myPreviewEditor.updateView();
            this.myWrapper.add((Component)InitialConfigurationDialog.this.myPreviewEditor.getPanel(), "East");
            if (recalculateDialogSize) {
                InitialConfigurationDialog dialog = InitialConfigurationDialog.this;
                InitialConfigurationDialog.this.resizeTo(dialog.getSize().width, dialog.getSize().height - wrapperHeight + InitialConfigurationDialog.this.getPreviewPreferredHeight());
            }
        }
    }
}

