/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocumentChangesCollector
implements DocumentListener {
    private final List<TextChangeImpl> myChanges = new ArrayList<TextChangeImpl>();
    private boolean myCollectChanges;

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.myCollectChanges) {
            return;
        }
        StringBuilder oldText = new StringBuilder(event.getOldFragment());
        this.cutChangesIfNecessary(event, oldText);
        this.updateChanges(event, oldText);
        this.mergeChangesIfNecessary(event);
    }

    private void cutChangesIfNecessary(DocumentEvent event, StringBuilder oldText) {
        TextChangeImpl change;
        int forwardIndex;
        if (this.myChanges.isEmpty()) {
            return;
        }
        int start = event.getOffset();
        int end = event.getOffset() + event.getOldLength();
        int diff = event.getNewLength() - event.getOldLength();
        int backwardIndexStart = forwardIndex - 1;
        if (forwardIndex < 0) {
            backwardIndexStart = this.myChanges.size() - 1;
        } else {
            TIntArrayList indices = new TIntArrayList();
            for (forwardIndex = this.findIndex(start); forwardIndex < this.myChanges.size(); ++forwardIndex) {
                int deleteEnd;
                int deleteStart;
                TextChangeImpl change2 = this.myChanges.get(forwardIndex);
                if (change2.getStart() >= end) {
                    change2.advance(diff);
                    continue;
                }
                if (change2.getEnd() <= end) {
                    indices.add(forwardIndex);
                    deleteStart = start - change2.getStart();
                    deleteStart = Math.max(0, deleteStart);
                    deleteEnd = change2.getEnd() - change2.getStart();
                    deleteEnd = Math.min(oldText.length(), Math.max(0, deleteEnd));
                    oldText.delete(deleteStart, deleteEnd);
                    oldText.insert(0, change2.getText());
                    continue;
                }
                deleteStart = change2.getStart() - start;
                deleteStart = Math.min(oldText.length(), Math.max(0, deleteStart));
                deleteEnd = oldText.length();
                deleteEnd = Math.min(oldText.length(), Math.max(0, deleteEnd));
                oldText.delete(deleteStart, deleteEnd);
                this.myChanges.set(forwardIndex, new TextChangeImpl(change2.getText(), end + diff, change2.getEnd() + diff));
            }
            if (!indices.isEmpty()) {
                for (int i = indices.size() - 1; i >= 0; --i) {
                    this.myChanges.remove(indices.get(i));
                }
            }
        }
        for (int i = Math.min(backwardIndexStart, this.myChanges.size() - 1); i >= 0 && (change = this.myChanges.get(i)).getEnd() > start; --i) {
            CharSequence textToUse = change.getText();
            int symbolsToCut = Math.min(change.getEnd(), end) - start;
            if (textToUse.length() >= symbolsToCut) {
                oldText.insert(symbolsToCut, textToUse.subSequence(textToUse.length() - symbolsToCut, textToUse.length()));
                textToUse = textToUse.subSequence(0, textToUse.length() - symbolsToCut);
            }
            oldText.delete(0, symbolsToCut);
            this.myChanges.set(i, new TextChangeImpl(textToUse, change.getStart(), start));
            if (change.getEnd() <= end) continue;
            int shift = event.getOffset() + event.getNewLength() - end;
            TextChangeImpl changeTail = new TextChangeImpl("", end + shift, change.getEnd() + shift);
            if (i >= this.myChanges.size() - 1) {
                this.myChanges.add(changeTail);
                continue;
            }
            this.myChanges.add(i + 1, changeTail);
        }
    }

    private void updateChanges(DocumentEvent event, StringBuilder oldText) {
        int i = this.findIndex(event.getOffset());
        int endOffset = event.getOffset() + event.getNewLength();
        TextChangeImpl change = new TextChangeImpl(oldText, event.getOffset(), endOffset);
        if (i < 0) {
            this.myChanges.add(change);
        } else {
            this.myChanges.add(i, change);
        }
    }

    private void mergeChangesIfNecessary(DocumentEvent event) {
        TextChangeImpl current;
        if (this.myChanges.size() < 2) {
            return;
        }
        TextChangeImpl next = this.myChanges.get(this.myChanges.size() - 1);
        for (int i = this.myChanges.size() - 2; i >= 0 && (current = this.myChanges.get(i)).getEnd() >= event.getOffset(); --i) {
            if (current.getEnd() == next.getStart()) {
                next = new TextChangeImpl(current.getText().toString() + next.getText(), current.getStart(), next.getEnd());
                this.myChanges.set(i, next);
                this.myChanges.remove(i + 1);
                continue;
            }
            next = current;
        }
    }

    @NotNull
    public List<? extends TextChange> getChanges() {
        return this.myChanges;
    }

    public void setCollectChanges(boolean collectChanges) {
        this.myCollectChanges = collectChanges;
    }

    public void reset() {
        this.myChanges.clear();
    }

    private int findIndex(int offset) {
        if (this.myChanges.isEmpty()) {
            return -1;
        }
        TextChangeImpl change = this.myChanges.get(this.myChanges.size() - 1);
        if (offset > change.getStart()) {
            return -1;
        }
        int start = 0;
        int end = this.myChanges.size() - 1;
        int result = -1;
        while (start <= end) {
            result = end + start >>> 1;
            change = this.myChanges.get(result);
            if (change.getStart() < offset) {
                start = ++result;
                continue;
            }
            if (change.getStart() <= offset) break;
            end = result - 1;
        }
        return result;
    }
}

