/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.dvcs.DvcsCommitAdditionalComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgActionUtil;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.command.mq.HgQNewCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCurrentBinaryContentRevision;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCheckinEnvironment
implements CheckinEnvironment {
    private final Project myProject;
    private boolean myNextCommitIsPushed;
    private boolean myNextCommitAmend;
    private boolean myShouldCommitSubrepos;
    private boolean myMqNewPatch;
    private boolean myCloseBranch;
    @Nullable
    private Collection<HgRepository> myRepos;

    public HgCheckinEnvironment(Project project) {
        this.myProject = project;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        this.reset();
        return new HgCommitAdditionalComponent(this.myProject, panel);
    }

    private void reset() {
        this.myNextCommitIsPushed = false;
        this.myShouldCommitSubrepos = false;
        this.myCloseBranch = false;
        this.myMqNewPatch = false;
        this.myRepos = null;
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return HgVcsMessages.message("hg4idea.commit", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        Map<HgRepository, Set<HgFile>> repositoriesMap = this.getFilesByRepository(changes);
        this.addRepositoriesWithoutChanges(repositoriesMap);
        for (Map.Entry<HgRepository, Set<HgFile>> entry : repositoriesMap.entrySet()) {
            HgCommitTypeCommand command;
            HgRepository repo = entry.getKey();
            Set<HgFile> selectedFiles = entry.getValue();
            HgCommitTypeCommand hgCommitTypeCommand = this.myMqNewPatch ? new HgQNewCommand(this.myProject, repo, preparedComment, this.myNextCommitAmend) : (command = new HgCommitCommand(this.myProject, repo, preparedComment, this.myNextCommitAmend, this.myCloseBranch, this.myShouldCommitSubrepos && !selectedFiles.isEmpty()));
            if (this.isMergeCommit(repo.getRoot())) {
                boolean partial;
                Set<HgFile> changedFilesNotInCommit = this.getChangedFilesNotInCommit(repo.getRoot(), selectedFiles);
                boolean bl = partial = !changedFilesNotInCommit.isEmpty();
                if (partial) {
                    StringBuilder filesNotIncludedString = new StringBuilder();
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        filesNotIncludedString.append("<li>");
                        filesNotIncludedString.append(hgFile.getRelativePath());
                        filesNotIncludedString.append("</li>");
                    }
                    if (!this.mayCommitEverything(filesNotIncludedString.toString())) {
                        return exceptions;
                    }
                    VcsDirtyScopeManager dirtyManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        dirtyManager.fileDirty(hgFile.toFilePath());
                    }
                }
            } else {
                command.setFiles(selectedFiles);
            }
            try {
                command.execute();
            }
            catch (HgCommandException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        if (this.myNextCommitIsPushed && exceptions.isEmpty()) {
            final ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositoriesMap.keySet());
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    new VcsPushDialog(HgCheckinEnvironment.this.myProject, preselectedRepositories, (Repository)HgUtil.getCurrentRepository(HgCheckinEnvironment.this.myProject)).show();
                }
            });
        }
        return exceptions;
    }

    private boolean isMergeCommit(VirtualFile repo) {
        return new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo).size() > 1;
    }

    private Set<HgFile> getChangedFilesNotInCommit(VirtualFile repo, Set<HgFile> selectedFiles) {
        List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo);
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).baseRevision(parents.get(0)).build(this.myProject);
        Set<HgChange> allChangedFilesInRepo = statusCommand.execute(repo);
        HashSet<HgFile> filesNotIncluded = new HashSet<HgFile>();
        for (HgChange change : allChangedFilesInRepo) {
            HgFile beforeFile = change.beforeFile();
            HgFile afterFile = change.afterFile();
            if (!selectedFiles.contains(beforeFile)) {
                filesNotIncluded.add(beforeFile);
                continue;
            }
            if (selectedFiles.contains(afterFile)) continue;
            filesNotIncluded.add(afterFile);
        }
        return filesNotIncluded;
    }

    private boolean mayCommitEverything(final String filesNotIncludedString) {
        final int[] choice = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                choice[0] = Messages.showOkCancelDialog((Project)HgCheckinEnvironment.this.myProject, (String)HgVcsMessages.message("hg4idea.commit.partial.merge.message", filesNotIncludedString), (String)HgVcsMessages.message("hg4idea.commit.partial.merge.title", new Object[0]), null);
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.defaultModalityState());
        return choice[0] == 0;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        final ArrayList<HgFile> filesWithRoots = new ArrayList<HgFile>();
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (vcsRoot == null) continue;
            filesWithRoots.add(new HgFile(vcsRoot, filePath));
        }
        new Task.Backgroundable(this.myProject, "Removing files..."){

            public void run(@NotNull ProgressIndicator indicator) {
                HgRemoveCommand command = new HgRemoveCommand(this.myProject);
                command.execute(filesWithRoots);
            }
        }.queue();
        return null;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        new HgAddCommand(this.myProject).addWithProgress(files);
        return null;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @NotNull
    private Map<HgRepository, Set<HgFile>> getFilesByRepository(List<Change> changes) {
        HashMap<HgRepository, Set<HgFile>> result = new HashMap<HgRepository, Set<HgFile>>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision != null) {
                this.addFile(result, afterRevision);
            }
            if (beforeRevision == null) continue;
            this.addFile(result, beforeRevision);
        }
        return result;
    }

    private void addFile(Map<HgRepository, Set<HgFile>> result, ContentRevision contentRevision) {
        FilePath filePath = contentRevision.getFile();
        HgRepository repo = HgUtil.getRepositoryForFile(this.myProject, contentRevision instanceof HgCurrentBinaryContentRevision ? ((HgCurrentBinaryContentRevision)contentRevision).getRepositoryRoot() : ChangesUtil.findValidParentAccurately((FilePath)filePath));
        if (repo == null) {
            return;
        }
        Set<HgFile> hgFiles = result.get(repo);
        if (hgFiles == null) {
            hgFiles = new HashSet<HgFile>();
            result.put(repo, hgFiles);
        }
        hgFiles.add(new HgFile(repo.getRoot(), filePath));
    }

    public void setNextCommitIsPushed() {
        this.myNextCommitIsPushed = true;
    }

    public void setMqNew() {
        this.myMqNewPatch = true;
    }

    public void setCloseBranch(boolean closeBranch) {
        this.myCloseBranch = closeBranch;
    }

    public void setRepos(@NotNull Collection<HgRepository> repos) {
        this.myRepos = repos;
    }

    private void addRepositoriesWithoutChanges(@NotNull Map<HgRepository, Set<HgFile>> repositoryMap) {
        if (this.myRepos == null) {
            return;
        }
        for (HgRepository repository : this.myRepos) {
            if (repositoryMap.keySet().contains(repository)) continue;
            repositoryMap.put(repository, Collections.emptySet());
        }
    }

    private class HgCommitAdditionalComponent
    extends DvcsCommitAdditionalComponent {
        @NotNull
        private final JCheckBox myCommitSubrepos;

        public HgCommitAdditionalComponent(@NotNull Project project, CheckinProjectPanel panel) {
            super(project, panel);
            HgVcs myVcs = HgVcs.getInstance(HgCheckinEnvironment.this.myProject);
            this.myAmend.setEnabled(myVcs != null && myVcs.getVersion().isAmendSupported());
            this.myAmend.setText(this.myAmend.getText() + " (QRefresh)");
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.insets = insets;
            c.gridx = 1;
            c.gridy = 2;
            c.weightx = 1.0;
            c.fill = 2;
            this.myCommitSubrepos = new JCheckBox("Commit subrepositories", false);
            this.myCommitSubrepos.setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)"Commit all subrepos for selected repositories.<br> <code>hg ci <i><b>files</b></i> -S <i><b>subrepos</b></i></code>"));
            this.myCommitSubrepos.setMnemonic('s');
            this.myPanel.add((Component)this.myCommitSubrepos, c);
            List<HgRepository> repos = HgActionUtil.collectRepositoriesFromFiles(HgUtil.getRepositoryManager(HgCheckinEnvironment.this.myProject), this.myCheckinPanel.getRoots());
            this.myCommitSubrepos.setVisible(ContainerUtil.exists(repos, (Condition)new Condition<HgRepository>(){

                public boolean value(HgRepository repository) {
                    return repository.hasSubrepos();
                }
            }));
            this.myCommitSubrepos.addActionListener(new MySelectionListener(this.myAmend));
            this.myAmend.addActionListener(new MySelectionListener(this.myCommitSubrepos));
        }

        public void refresh() {
            super.refresh();
            this.restoreState();
        }

        public void saveState() {
            HgCheckinEnvironment.this.myNextCommitAmend = this.myAmend.isSelected();
            HgCheckinEnvironment.this.myShouldCommitSubrepos = this.myCommitSubrepos.isSelected();
        }

        public void restoreState() {
            HgCheckinEnvironment.this.myNextCommitAmend = false;
            HgCheckinEnvironment.this.myShouldCommitSubrepos = false;
        }

        @NotNull
        protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> filePaths) {
            return HgUtil.hgRoots(HgCheckinEnvironment.this.myProject, filePaths);
        }

        @Nullable
        protected String getLastCommitMessage(@NotNull VirtualFile repo) throws VcsException {
            HgCommandExecutor commandExecutor = new HgCommandExecutor(HgCheckinEnvironment.this.myProject);
            ArrayList<String> args = new ArrayList<String>();
            args.add("-r");
            args.add(".");
            args.add("--template");
            args.add("{desc}");
            HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "log", args);
            return result == null ? "" : result.getRawOutput();
        }

        private class MySelectionListener
        implements ActionListener {
            private final JCheckBox myUnselectedComponent;

            public MySelectionListener(JCheckBox unselectedComponent) {
                this.myUnselectedComponent = unselectedComponent;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (source.isSelected()) {
                    this.myUnselectedComponent.setSelected(false);
                    this.myUnselectedComponent.setEnabled(false);
                } else {
                    this.myUnselectedComponent.setEnabled(true);
                }
            }
        }
    }
}

