/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

class HgCommandProcessHandler
extends OSProcessHandler {
    private final boolean myBinary;
    private final ByteArrayOutputStream myBinaryOutput;

    HgCommandProcessHandler(@NotNull GeneralCommandLine commandLine, boolean binary) throws ExecutionException {
        super(commandLine);
        this.myBinary = binary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(@NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        return this.myBinary ? new MyBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy) : super.createOutputDataReader(sleepingPolicy);
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        return this.myBinaryOutput;
    }

    private class MyBinaryOutputReader
    extends BinaryOutputReader {
        private MyBinaryOutputReader(@NotNull InputStream stream, BaseDataReader.SleepingPolicy simple) {
            super(stream, simple);
            this.start(HgCommandProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(@NotNull byte[] data, int size) {
            HgCommandProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return HgCommandProcessHandler.this.executeOnPooledThread(runnable);
        }
    }
}

