/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQDeleteCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQDeleteCommand(@NotNull HgRepository repository) {
        this.myRepository = repository;
    }

    public void execute(final @NotNull List<String> patchNames) {
        final Project project = this.myRepository.getProject();
        new HgCommandExecutor(project).execute(this.myRepository.getRoot(), "qdelete", patchNames, new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "QDelete command failed", "Could not delete selected " + StringUtil.pluralize((String)"patch", (int)patchNames.size()));
                }
                HgQDeleteCommand.this.myRepository.update();
            }
        });
    }
}

