/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgGraftCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;

    public HgGraftCommand(@NotNull Project project, @NotNull HgRepository repo) {
        this.myProject = project;
        this.myRepository = repo;
    }

    @Nullable
    public HgCommandResult startGrafting(List<String> hashes) {
        return this.graft(hashes);
    }

    @Nullable
    public HgCommandResult continueGrafting() {
        return this.graft(Collections.singletonList("--continue"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HgCommandResult graft(@NotNull List<String> params) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--log");
        args.addAll(params);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            HgCommandResult result = new HgCommandExecutor(this.myProject).executeInCurrentThread(this.myRepository.getRoot(), "graft", args);
            this.myRepository.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }
}

