/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.mq.HgMqAppliedPatchAction;
import org.zmlx.hg4idea.action.mq.HgShowUnAppliedPatchesAction;
import org.zmlx.hg4idea.command.mq.HgQGotoCommand;
import org.zmlx.hg4idea.command.mq.HgQPopCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgQGotoFromLogAction
extends HgMqAppliedPatchAction {
    protected void actionPerformed(final @NotNull HgRepository repository, @NotNull VcsFullCommitDetails commit) {
        final Project project = repository.getProject();
        List parents = commit.getParents();
        final Hash parentHash = parents.isEmpty() ? null : (Hash)parents.get(0);
        final HgNameWithHashInfo parentPatchName = (HgNameWithHashInfo)ContainerUtil.find(repository.getMQAppliedPatches(), (Condition)new Condition<HgNameWithHashInfo>(){

            public boolean value(HgNameWithHashInfo info) {
                return info.getHash().equals(parentHash);
            }
        });
        new Task.Backgroundable(repository.getProject(), parentPatchName != null ? HgVcsMessages.message("hg4idea.mq.progress.goto", parentPatchName) : HgVcsMessages.message("hg4idea.mq.progress.pop", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (parentPatchName != null) {
                    new HgQGotoCommand(repository).executeInCurrentThread(parentPatchName.getName());
                } else {
                    new HgQPopCommand(repository).executeInCurrentThread();
                }
            }

            public void onSuccess() {
                HgShowUnAppliedPatchesAction.showUnAppliedPatches(project, repository);
            }
        }.queue();
    }

    protected void actionPerformed(@NotNull HgRepository repository, @NotNull Hash commit) {
        throw new UnsupportedOperationException();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log.requestSelectedDetails((Consumer)new Consumer<List<VcsFullCommitDetails>>(){

            public void consume(List<VcsFullCommitDetails> selectedDetails) {
                VcsFullCommitDetails fullCommitDetails = (VcsFullCommitDetails)ContainerUtil.getFirstItem(selectedDetails);
                assert (fullCommitDetails != null);
                HgRepository repository = HgQGotoFromLogAction.this.getRepositoryForRoot(project, fullCommitDetails.getRoot());
                assert (repository != null);
                HgQGotoFromLogAction.this.actionPerformed(repository, fullCommitDetails);
            }
        }, null);
    }
}

