/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRootsHandler
implements AbstractVcs.RootsConvertor {
    public static HgRootsHandler getInstance(Project project) {
        return (HgRootsHandler)ServiceManager.getService((Project)project, HgRootsHandler.class);
    }

    @NotNull
    public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> original) {
        THashSet result = new THashSet(original.size());
        for (VirtualFile vf : original) {
            VirtualFile root = HgRootsHandler.convertRoot(vf);
            if (root == null) continue;
            result.add(root);
        }
        return new ArrayList<VirtualFile>((Collection<VirtualFile>)result);
    }

    @Nullable
    private static VirtualFile convertRoot(@Nullable VirtualFile root) {
        return HgUtil.isHgRoot(root) ? root : null;
    }
}

