/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessRecorder;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ProcessRecorderFactory {
    private static boolean sENABLED = !Strings.isNullOrEmpty((String)System.getenv("RECORD_SPANS"));
    private ScheduledExecutorService mScheduledExecutorService = Executors.newScheduledThreadPool(1);
    private ILogger mLogger = null;
    private static final Object LOCK = new Object();
    static ProcessRecorderFactory sINSTANCE = new ProcessRecorderFactory();
    private ProcessRecorder processRecorder = null;
    private ProcessRecorder.ExecutionRecordWriter recordWriter = null;
    private File outputFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                sINSTANCE.get().finish();
                sINSTANCE.uploadData();
            }
            ProcessRecorderFactory.sINSTANCE.processRecorder = null;
        }
    }

    ProcessRecorderFactory() {
    }

    static boolean isEnabled() {
        return sENABLED;
    }

    static void setEnabled(boolean enabled) {
        sENABLED = enabled;
    }

    public synchronized void setRecordWriter(ProcessRecorder.ExecutionRecordWriter recordWriter) {
        this.assertRecorderNotCreated();
        this.recordWriter = recordWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(File projectPath, String gradleVersion, ILogger logger, File out) {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                return;
            }
            sINSTANCE.setLogger(logger);
            if (ProcessRecorderFactory.isEnabled()) {
                sINSTANCE.setOutputFile(out);
                try {
                    sINSTANCE.setRecordWriter(new ProcessRecorder.JsonRecordWriter(new FileWriter(out)));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to open json profile for writing", e);
                }
            }
            ProcessRecorder recorder = sINSTANCE.get();
            ProcessRecorderFactory.setGlobalProperties(recorder, projectPath, gradleVersion, logger);
        }
    }

    private static void setGlobalProperties(ProcessRecorder recorder, File projectPath, String gradleVersion, ILogger logger) {
        recorder.getProperties().setOsName(Strings.nullToEmpty((String)System.getProperty("os.name"))).setOsVersion(Strings.nullToEmpty((String)System.getProperty("os.version"))).setJavaVersion(Strings.nullToEmpty((String)System.getProperty("java.version"))).setJavaVmVersion(Strings.nullToEmpty((String)System.getProperty("java.vm.version"))).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(Strings.nullToEmpty((String)gradleVersion));
        try {
            recorder.getProperties().setProjectId(Anonymizer.anonymizeUtf8((ILogger)logger, (String)projectPath.getAbsolutePath()));
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Could not anonymize project id.", new Object[0]);
        }
    }

    public synchronized void setLogger(ILogger iLogger) {
        this.assertRecorderNotCreated();
        this.mLogger = iLogger;
    }

    public static ProcessRecorderFactory getFactory() {
        return sINSTANCE;
    }

    boolean isInitialized() {
        return this.processRecorder != null;
    }

    private void assertRecorderNotCreated() {
        if (this.isInitialized()) {
            throw new RuntimeException("ProcessRecorder already created.");
        }
    }

    public static void initializeForTests(ProcessRecorder.ExecutionRecordWriter recordWriter) {
        sINSTANCE = new ProcessRecorderFactory();
        ProcessRecorder.resetForTests();
        ProcessRecorderFactory.setEnabled(true);
        sINSTANCE.setRecordWriter(recordWriter);
        ProcessRecorder recorder = sINSTANCE.get();
        ProcessRecorderFactory.setGlobalProperties(recorder, new File("fake/path/to/test_project/"), "2.10", (ILogger)new StdLogger(StdLogger.Level.VERBOSE));
    }

    private static void initializeAnalytics(ILogger logger, ScheduledExecutorService eventLoop) {
        AnalyticsSettings settings;
        try {
            settings = AnalyticsSettings.loadSettings();
            if (settings == null) {
                settings = AnalyticsSettings.createNewAnalyticsSettings();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Could not initialize analytics, treating as opt-out.", new Object[0]);
            settings = new AnalyticsSettings();
            settings.setHasOptedIn(false);
        }
        UsageTracker.initialize((AnalyticsSettings)settings, (ScheduledExecutorService)eventLoop);
        UsageTracker tracker = UsageTracker.getInstance();
        tracker.setMaxJournalTime(10L, TimeUnit.MINUTES);
        tracker.setMaxJournalSize(1000);
    }

    private void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    synchronized ProcessRecorder get() {
        if (this.processRecorder == null) {
            if (this.mLogger == null) {
                this.mLogger = new StdLogger(StdLogger.Level.INFO);
            }
            ProcessRecorderFactory.initializeAnalytics(this.mLogger, this.mScheduledExecutorService);
            this.processRecorder = new ProcessRecorder(this.recordWriter, this.mLogger);
        }
        return this.processRecorder;
    }

    private void uploadData() {
        block41: {
            if (this.outputFile == null) {
                return;
            }
            try {
                URL u = new URL("http://android-devtools-logging.appspot.com/log/");
                HttpURLConnection conn = (HttpURLConnection)u.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(this.outputFile.length()));
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.outputFile));
                     OutputStream os = conn.getOutputStream();){
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (this.mLogger == null) continue;
                        this.mLogger.info("From POST : " + line, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                if (this.mLogger == null) break block41;
                this.mLogger.warning("An exception while generated while uploading the profiler data", new Object[0]);
                this.mLogger.error((Throwable)e, "Exception while uploading the profiler data", new Object[0]);
            }
        }
    }
}

