/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.utils;

import com.android.builder.internal.utils.IOExceptionFunction;
import com.android.builder.internal.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FileCache {
    public static final FileCache NO_CACHE = new FileCache(){

        @Override
        public boolean getOrCreateFile(File outputFile, Inputs inputs, IOExceptionFunction<File, Void> fileProducer) throws IOException {
            FileUtils.deletePath((File)outputFile);
            Files.createParentDirs((File)outputFile);
            fileProducer.apply(outputFile);
            return outputFile.exists();
        }
    };
    private final File mCacheDirectory;
    private final boolean mInterProcessLocking;
    private final AtomicInteger mMisses = new AtomicInteger(0);
    private final AtomicInteger mHits = new AtomicInteger(0);

    private FileCache() {
        this.mCacheDirectory = new File("");
        this.mInterProcessLocking = false;
    }

    private FileCache(File cacheDirectory, boolean interProcessLocking) {
        FileUtils.mkdirs((File)cacheDirectory);
        this.mCacheDirectory = cacheDirectory;
        this.mInterProcessLocking = interProcessLocking;
    }

    public static FileCache withInterProcessLocking(File cacheDirectory) {
        return new FileCache(cacheDirectory, true);
    }

    public static FileCache withSingleProcessLocking(File cacheDirectory) {
        return new FileCache(cacheDirectory, false);
    }

    public boolean getOrCreateFile(File outputFile, Inputs inputs, IOExceptionFunction<File, Void> fileProducer) throws IOException {
        File cachedFileContainer = new File(this.mCacheDirectory, inputs.getKey());
        File cachedFile = new File(cachedFileContainer, "output");
        File inputsFile = new File(cachedFileContainer, "inputs");
        this.doLocked(cachedFileContainer, () -> {
            if (!cachedFileContainer.exists()) {
                this.mMisses.incrementAndGet();
                FileUtils.mkdirs((File)cachedFileContainer);
                File tmpFile = new File(cachedFileContainer, outputFile.getName());
                boolean success = false;
                try {
                    fileProducer.apply(tmpFile);
                    success = true;
                }
                finally {
                    if (!success) {
                        FileUtils.deletePath((File)cachedFileContainer);
                    }
                }
                if (tmpFile.exists() && !tmpFile.equals(cachedFile)) {
                    Files.move((File)tmpFile, (File)cachedFile);
                }
                Files.write((CharSequence)inputs.toString(), (File)inputsFile, (Charset)StandardCharsets.UTF_8);
            } else {
                this.mHits.incrementAndGet();
            }
        }, this.mInterProcessLocking);
        if (cachedFile.exists()) {
            this.doLocked(outputFile, () -> FileCache.copyFileOrDirectory(cachedFile, outputFile), this.mInterProcessLocking);
            return true;
        }
        return false;
    }

    void doLocked(File accessedFile, IOExceptionRunnable task, boolean interProcessLocking) throws IOException {
        if (interProcessLocking) {
            this.doProcessLocked(accessedFile, task);
        } else {
            this.doThreadLocked(accessedFile, task);
        }
    }

    private void doProcessLocked(File accessedFile, IOExceptionRunnable task) throws IOException {
        this.doThreadLocked(accessedFile, () -> {
            String lockFileName = Hashing.sha1().hashString((CharSequence)accessedFile.getCanonicalPath(), StandardCharsets.UTF_8).toString();
            File lockFile = new File(this.mCacheDirectory, lockFileName);
            FileChannel fileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            FileLock fileLock = fileChannel.lock();
            try {
                task.run();
            }
            finally {
                lockFile.delete();
                fileLock.release();
                fileChannel.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doThreadLocked(File accessedFile, IOExceptionRunnable task) throws IOException {
        String string = (this.mCacheDirectory.getCanonicalPath() + accessedFile.getCanonicalPath()).intern();
        synchronized (string) {
            task.run();
        }
    }

    private static void copyFileOrDirectory(File from, File to) throws IOException {
        assert (from.exists()) : "Source path " + from.getCanonicalPath() + "does not exist.";
        if (!from.getCanonicalPath().equals(to.getCanonicalPath())) {
            if (from.isFile()) {
                Files.createParentDirs((File)to);
                FileUtils.copyFile((File)from, (File)to);
            } else if (from.isDirectory()) {
                FileUtils.deletePath((File)to);
                FileUtils.copyDirectory((File)from, (File)to);
            }
        }
    }

    int getMisses() {
        return this.mMisses.get();
    }

    int getHits() {
        return this.mHits.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cacheDirectory", (Object)this.mCacheDirectory).add("interProcessLocking", this.mInterProcessLocking).toString();
    }

    public static class Inputs {
        private final LinkedHashMap<String, String> mParameters;

        private Inputs(Builder builder) {
            this.mParameters = Maps.newLinkedHashMap((Map)builder.mParameters);
        }

        public String toString() {
            return Joiner.on((String)System.lineSeparator()).withKeyValueSeparator("=").join(this.mParameters);
        }

        public String getKey() {
            return Hashing.sha1().hashString((CharSequence)this.toString(), StandardCharsets.UTF_8).toString();
        }

        public static class Builder {
            private final LinkedHashMap<String, String> mParameters = Maps.newLinkedHashMap();

            public Builder put(String name, File value) {
                this.mParameters.put(name, value.getPath());
                return this;
            }

            public Builder put(String name, String value) {
                this.mParameters.put(name, value);
                return this;
            }

            public Builder put(String name, boolean value) {
                this.mParameters.put(name, String.valueOf(value));
                return this;
            }

            public Inputs build() {
                if (this.mParameters.isEmpty()) {
                    throw new IllegalStateException("Inputs must not be empty.");
                }
                return new Inputs(this);
            }
        }
    }
}

