/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.JackProcessOptions;
import com.android.builder.internal.compiler.JackDexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.process.ProcessException;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class JackConversionCache
extends PreProcessCache<JackDexKey> {
    private static final JackConversionCache sSingleton = new JackConversionCache();

    public static JackConversionCache getCache() {
        return sSingleton;
    }

    @Override
    protected PreProcessCache.KeyFactory<JackDexKey> getKeyFactory() {
        return JackDexKey.FACTORY;
    }

    public void convertLibrary(AndroidBuilder androidBuilder, File inputFile, File outFile, JackProcessOptions options, boolean isJackInProcess) throws ConfigNotSupportedException, ClassNotFoundException, ConfigurationException, CompilationException, UnrecoverableException, ProcessException, InterruptedException, IOException {
        Preconditions.checkNotNull((Object)androidBuilder.getTargetInfo());
        JackDexKey itemKey = JackDexKey.of(inputFile, androidBuilder.getTargetInfo().getBuildTools().getRevision(), options.getJumboMode(), options.getDexOptimize(), options.getAdditionalParameters());
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(androidBuilder.getLogger(), itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                androidBuilder.convertByteCodeUsingJack(options, isJackInProcess);
                item.getOutputFiles().add(outFile);
                this.incrementMisses();
            }
            catch (Exception exception) {
                outFile.delete();
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else {
            item.getLatch().await();
            File fromFile = item.getOutputFiles().get(0);
            if (!fromFile.getCanonicalPath().equals(outFile.getCanonicalPath()) && fromFile.isFile()) {
                FileUtils.mkdirs((File)outFile.getParentFile());
                Files.copy((File)fromFile, (File)outFile);
                this.incrementHits();
            }
        }
    }
}

