/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.Screenshot;
import com.google.api.client.util.Lists;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gct.studio.util.GctStudioBundle;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SamplePreviewPanel
extends JPanel
implements ComponentListener {
    private List<BufferedImage> myImages = Lists.newArrayList();
    private List<Image> myScaledImages = Lists.newArrayList();
    private final LoadingCache<String, BufferedImage> myImageCache;
    private int myHeight = 0;
    private boolean myHasPreview = false;
    private static int PADDING = 5;
    private SwingWorker myBackgroundTask = null;

    public SamplePreviewPanel() {
        this.addComponentListener(this);
        this.myImageCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, BufferedImage>(){

            public BufferedImage load(@NotNull String imageUrl) throws Exception {
                return ImageIO.read(new URL(imageUrl));
            }
        });
    }

    public void setSample(@Nullable Sample sample) {
        this.myImages.clear();
        this.myScaledImages.clear();
        this.myHeight = 0;
        if (this.myBackgroundTask != null) {
            this.myBackgroundTask.cancel(true);
            this.myBackgroundTask = null;
        }
        if (sample == null || sample.getScreenshots() == null || sample.getScreenshots().size() == 0) {
            this.myHasPreview = false;
            this.revalidate();
            this.repaint();
        } else {
            this.myHasPreview = true;
            this.revalidate();
            this.repaint();
            this.loadImagesInBackground(sample);
        }
    }

    private void loadImagesInBackground(final @NotNull Sample sample) {
        this.myBackgroundTask = new SwingWorker<List<BufferedImage>, Void>(){

            @Override
            @Nullable
            protected List<BufferedImage> doInBackground() throws Exception {
                ArrayList images = Lists.newArrayList();
                for (Screenshot screenshot : sample.getScreenshots()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    try {
                        String url = screenshot.getLink();
                        BufferedImage image = (BufferedImage)SamplePreviewPanel.this.myImageCache.get((Object)url);
                        images.add(image);
                    }
                    catch (Exception exception) {}
                }
                return images;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    List result = (List)this.get();
                    if (result != null) {
                        SamplePreviewPanel.this.myImages = result;
                        if (SamplePreviewPanel.this.myImages.size() == 0) {
                            SamplePreviewPanel.this.myHasPreview = false;
                        }
                        SamplePreviewPanel.this.scaleImages();
                        SamplePreviewPanel.this.revalidate();
                        SamplePreviewPanel.this.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        this.myBackgroundTask.execute();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int yPos = 0;
        if (this.myScaledImages.size() == 0) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            String text = GctStudioBundle.message("sample.browser.no.preview", new Object[0]);
            if (this.myHasPreview) {
                text = "Loading preview...";
            }
            Rectangle2D r = g.getFontMetrics().getStringBounds(text, g);
            g.drawString(text, 1, (int)r.getHeight());
        }
        for (Image img : this.myScaledImages) {
            g.drawImage(img, 0, yPos, null);
            yPos += img.getHeight(null) + PADDING;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.myHeight);
    }

    private void scaleImages() {
        this.myHeight = 0;
        this.myScaledImages.clear();
        for (BufferedImage img : this.myImages) {
            int yScaled = img.getHeight() * this.getWidth() / img.getWidth();
            this.myScaledImages.add(img.getScaledInstance(this.getWidth(), yScaled, 4));
            this.myHeight += yScaled + PADDING;
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.scaleImages();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

