/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Exception e) {
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        LOG.info(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String logDetails) {
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        LOG.warn(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showInfoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Project)project, (String)message, (String)title);
    }

    public static void showInfoDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Component)component, (String)message, (String)title);
    }

    public static void showWarningDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showWarningDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Component)component, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        LOG.warn(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Project)project, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull Exception e) {
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull String prefix, @NotNull Exception e) {
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)(prefix + GithubUtil.getErrorTextFromException(e)), (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message, @NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
    }
}

