/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubSelectForkPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;

public class GithubSelectForkDialog
extends DialogWrapper {
    @NotNull
    private final GithubSelectForkPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Convertor<String, GithubCreatePullRequestWorker.ForkInfo> myCheckFork;
    private GithubCreatePullRequestWorker.ForkInfo mySelectedFork;

    public GithubSelectForkDialog(@NotNull Project project, @Nullable List<GithubFullPath> forks, @NotNull Convertor<String, GithubCreatePullRequestWorker.ForkInfo> checkFork) {
        super(project);
        this.myProject = project;
        this.myCheckFork = checkFork;
        this.myPanel = new GithubSelectForkPanel();
        if (forks != null) {
            this.myPanel.setUsers(ContainerUtil.map(forks, (Function)new Function<GithubFullPath, String>(){

                public String fun(GithubFullPath path) {
                    return path.getUser();
                }
            }));
        }
        this.setTitle("Select Base Fork Repository");
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)this.myCheckFork.convert((Object)this.myPanel.getUser());
        if (fork == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Find Repository", "Can't find fork for selected user");
        } else {
            this.mySelectedFork = fork;
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @NotNull
    public GithubCreatePullRequestWorker.ForkInfo getPath() {
        return this.mySelectedFork;
    }
}

