/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubUserDetailed
extends GithubUser {
    @Nullable
    private final String myName;
    @Nullable
    private final String myEmail;
    @Nullable
    private final Integer myOwnedPrivateRepos;
    @Nullable
    private final String myType;
    @Nullable
    private final UserPlan myPlan;

    public boolean canCreatePrivateRepo() {
        return this.getPlan() == null || this.getOwnedPrivateRepos() == null || this.getPlan().getPrivateRepos() > (long)this.getOwnedPrivateRepos().intValue();
    }

    public GithubUserDetailed(@NotNull String login, @NotNull String htmlUrl, @Nullable String avatarUrl, @Nullable String name, @Nullable String email, @Nullable Integer ownedPrivateRepos, @Nullable String type, @Nullable UserPlan plan) {
        super(login, htmlUrl, avatarUrl);
        this.myName = name;
        this.myEmail = email;
        this.myOwnedPrivateRepos = ownedPrivateRepos;
        this.myType = type;
        this.myPlan = plan;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getEmail() {
        return this.myEmail;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    @Nullable
    public Integer getOwnedPrivateRepos() {
        return this.myOwnedPrivateRepos;
    }

    @Nullable
    public UserPlan getPlan() {
        return this.myPlan;
    }

    public static class UserPlan {
        @NotNull
        private final String myName;
        private final long myPrivateRepos;

        public UserPlan(@NotNull String name, long privateRepos) {
            this.myName = name;
            this.myPrivateRepos = privateRepos;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        public long getPrivateRepos() {
            return this.myPrivateRepos;
        }
    }
}

