/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubPullRequest {
    private final long myNumber;
    @NotNull
    private final String myState;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myBodyHtml;
    @NotNull
    private final String myHtmlUrl;
    @NotNull
    private final String myDiffUrl;
    @NotNull
    private final String myPatchUrl;
    @NotNull
    private final String myIssueUrl;
    @NotNull
    private final Date myCreatedAt;
    @NotNull
    private final Date myUpdatedAt;
    @Nullable
    private final Date myClosedAt;
    @Nullable
    private final Date myMergedAt;
    @NotNull
    private final GithubUser myUser;
    @NotNull
    private final Link myHead;
    @NotNull
    private final Link myBase;

    public GithubPullRequest(long number, @NotNull String state, @NotNull String title, @Nullable String bodyHtml, @NotNull String htmlUrl, @NotNull String diffUrl, @NotNull String patchUrl, @NotNull String issueUrl, @NotNull Date createdAt, @NotNull Date updatedAt, @Nullable Date closedAt, @Nullable Date mergedAt, @NotNull GithubUser user, @NotNull Link head, @NotNull Link base) {
        this.myNumber = number;
        this.myState = state;
        this.myTitle = title;
        this.myBodyHtml = StringUtil.notNullize((String)bodyHtml);
        this.myHtmlUrl = htmlUrl;
        this.myDiffUrl = diffUrl;
        this.myPatchUrl = patchUrl;
        this.myIssueUrl = issueUrl;
        this.myCreatedAt = createdAt;
        this.myUpdatedAt = updatedAt;
        this.myClosedAt = closedAt;
        this.myMergedAt = mergedAt;
        this.myUser = user;
        this.myHead = head;
        this.myBase = base;
    }

    public long getNumber() {
        return this.myNumber;
    }

    @NotNull
    public String getState() {
        return this.myState;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getBodyHtml() {
        return this.myBodyHtml;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    @NotNull
    public String getDiffUrl() {
        return this.myDiffUrl;
    }

    @NotNull
    public String getPatchUrl() {
        return this.myPatchUrl;
    }

    @NotNull
    public String getIssueUrl() {
        return this.myIssueUrl;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.myCreatedAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.myUpdatedAt;
    }

    @Nullable
    public Date getClosedAt() {
        return this.myClosedAt;
    }

    @Nullable
    public Date getMergedAt() {
        return this.myMergedAt;
    }

    @NotNull
    public GithubUser getUser() {
        return this.myUser;
    }

    @NotNull
    public Link getHead() {
        return this.myHead;
    }

    @NotNull
    public Link getBase() {
        return this.myBase;
    }

    public static class Link {
        @NotNull
        private final String myLabel;
        @NotNull
        private final String myRef;
        @NotNull
        private final String mySha;
        @NotNull
        private final GithubRepo myRepo;
        @NotNull
        private final GithubUser myUser;

        public Link(@NotNull String label, @NotNull String ref, @NotNull String sha, @NotNull GithubRepo repo, @NotNull GithubUser user) {
            this.myLabel = label;
            this.myRef = ref;
            this.mySha = sha;
            this.myRepo = repo;
            this.myUser = user;
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getRef() {
            return this.myRef;
        }

        @NotNull
        public String getSha() {
            return this.mySha;
        }

        @NotNull
        public GithubRepo getRepo() {
            return this.myRepo;
        }

        @NotNull
        public GithubUser getUser() {
            return this.myUser;
        }
    }
}

